#!/usr/bin/python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# Python Imports #####
import os
import ConfigParser
# local imports
from common_meta import MSingletonMeta
import neohost_exceptions
from path_provider import MPathProvider


# Singleton
class MConfParser(object):
    """MConfParser is a singleton that allows the parsing of the provided
    adminc_core.ini configuration file."""
    __metaclass__ = MSingletonMeta

    def __init__(self):
        core_conf_path = os.path.join(MPathProvider().get_root_dir(),
                                      "neohost_core.ini")
        if not os.path.exists(core_conf_path) or \
                not os.path.isfile(core_conf_path):
            raise neohost_exceptions.MConfParserError(
                "NeoHost configuration file path does not exist: %s" %
                core_conf_path)
        self.cfg_parser = ConfigParser.SafeConfigParser()
        self.cfg_parser.read(core_conf_path)

    def _get(self, method, section, option):
        """Retrieve an entry from neohost_core.ini file."""
        try:
            val = method(section, option)
        except ConfigParser.Error:
            raise neohost_exceptions.MConfParserError(
                "cannot get entry:'%s.%s' in NeoHost configuration file" %
                (section, option))
        return val

    def get(self, section, option):
        return self._get(self.cfg_parser.get, section, option)

    def getint(self, section, option):
        return self._get(self.cfg_parser.getint, section, option)

    def getboolean(self, section, option):
        return self._get(self.cfg_parser.getboolean, section, option)
