#!/usr/bin/python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# Python Imports

from common_meta import MEnumMeta


class EnumAttrMask(object):
    """Command type enum."""
    __metaclass__ = MEnumMeta
    Info_Entry_Desc = 1 << 0
    Info_Entry_Idx = 1 << 1


class InfoEntryCreator(object):
    def __init__(self, attr_mask=0):
        self.__attr_mask = attr_mask

    def set_attr_mask(self, attr_mask):
        self.__attr_mask = attr_mask

    def create_entry(
            self, display_name, entry_val_or_callable, description, idx):
        entry = dict()
        entry["displayName"] = display_name
        try:
            if hasattr(entry_val_or_callable, '__call__'):
                entry["val"] = str(entry_val_or_callable())
            else:
                entry["val"] = entry_val_or_callable
        except:
            entry["val"] = "N/A"
        if self.__attr_mask & EnumAttrMask.Info_Entry_Desc:
            entry["desc"] = description
        if self.__attr_mask & EnumAttrMask.Info_Entry_Idx:
            entry["idx"] = int(idx)
        return entry
