# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) 2016-2017, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

from common_meta import MEnumMeta


class JsonRpcErr(object):
    __metaclass__ = MEnumMeta
    # Invalid JSON was received by the server.
    # An error occurred on the server while parsing the JSON text.
    ParseError = -32700

    InvalidRequest = -32600  # The JSON sent is not a valid Request object.
    MethodNotFound = -32601  # The method does not exist / is not available.
    InvalidParams = -32602  # Invalid method parameter(s).
    InternalError = -32603  # Internal error    Internal JSON-RPC error.

    #  Server error Reserved for implementation-defined server-errors.
    # -32000 to -32099
    ServerError_First = -32000
    ServerError_Last = -32099
