# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) 2016-2017, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
'''
Created on Dec 13, 2016

@author: samerd
'''
from common_meta import MSingletonMeta
import logging
from neohost_exceptions import MMesaageHandlingError


logger = logging.getLogger("neohost." + __name__)


class MsgConstants:
    NEOHOST_REQUEST = "neohost_request"


class MsgMgr(object):
    '''
    classdocs
    '''
    __metaclass__ = MSingletonMeta

    def __init__(self):
        '''
        Constructor
        '''
        self._msg_handlers = {}
        self._supported_messages = (
            MsgConstants.NEOHOST_REQUEST,
            )

    def register(self, msg_type, handler):
        self._msg_handlers[msg_type] = handler

    def handle(self, msg_type, msg_data):
        if msg_type not in self._supported_messages:
            err = "unsupported msg: %s" % msg_type
            logger.error(err)
            raise MMesaageHandlingError(err)

        handler = self._msg_handlers.get(msg_type)
        if not handler:
            err = "no handler found for msg: %s" % msg_type
            logger.error(err)
            raise MMesaageHandlingError(err)
        resp = handler(msg_data)
        return resp
