#!/usr/bin/python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# Python Imports
import sys
import re

from neohost_exceptions import MException


class NeoHostCommon(object):
    development = False
    MAX_SUPP_PLUGIN_VERSION_MAJOR = 1
    neohost_stopped = False

    @classmethod
    def check_python_plugin_version(cls, version_major, version_minor):
        """Check if a plugin version is supported"""
        if version_major > cls.MAX_SUPP_PLUGIN_VERSION_MAJOR:
            raise MException("Unsupported plugin version")

    @classmethod
    def isWindowsOs(cls):
        return sys.platform.startswith('win')

    @classmethod
    def isFreebsdOs(cls):
        return sys.platform.lower().startswith('freebsd')

    @classmethod
    def isBlueFieldDevice(cls, devMstLine):
        return "41682" in devMstLine or "41683" in devMstLine

    @classmethod
    def PCIDevIdToFreebsdFormat(cls, pci_name):
        parser = re.compile(r"([0-9a-fA-F]+):([0-9a-fA-F]+):([0-9a-fA-F]+)\.([0-9]+)", re.IGNORECASE)
        match = parser.match(pci_name)
        if match is not None:
            return ("pci%d:%d:%d:%d") % (int(match.group(1),16),
                                        int(match.group(2),16),
                                        int(match.group(3),16),
                                        int(match.group(4),16))
        else:
            return pci_name
