#!/usr/bin/python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

"""
    NeoHost Exceptions module contains application specific exceptions
"""

from neohost_plugin_ifc import NeoHostBaseException
from jsonrpc_err import JsonRpcErr


class MException(NeoHostBaseException):
    """NeoHost Framework base exception."""
    def __init__(self, msg_str, error_code=1):
        super(MException, self).__init__(
            msg_str=msg_str, source_str="core", error_code=error_code)


class MParsingError(MException):
    """NeoHost framework parsing error exception."""
    def __init__(self, msg_str):
        super(MParsingError, self).__init__(
            msg_str=msg_str, error_code=JsonRpcErr.ParseError)


class MInvalidRequest(MException):
    """NeoHost framework parsing error exception."""
    def __init__(self, msg_str):
        super(MInvalidRequest, self).__init__(
            msg_str=msg_str, error_code=JsonRpcErr.InvalidRequest)


class MInvalidParams(MException):
    """NeoHost framework parsing error exception."""
    def __init__(self, msg_str):
        super(MInvalidParams, self).__init__(
            msg_str=msg_str, error_code=JsonRpcErr.InvalidParams)


class MMethodNotFound(MException):
    """NeoHost framework parsing error exception."""
    def __init__(self, msg_str):
        super(MMethodNotFound, self).__init__(
            msg_str=msg_str, error_code=JsonRpcErr.MethodNotFound)


class MInternalError(MException):
    """NeoHost framework parsing error exception."""
    def __init__(self, msg_str):
        super(MInternalError, self).__init__(
            msg_str=msg_str, error_code=JsonRpcErr.InternalError)


class MJsonConversionError(MInternalError):
    """NeoHost framework JSON conversion exception."""
    pass


class MInvalidResponse(MInternalError):
    """NeoHost framework JSON schema validation exception."""
    pass


class MPathError(MInternalError):
    """NeoHost framework Path exception."""
    pass


class MConfParserError(MInternalError):
    """NeoHost framework Configuration parser exception."""
    pass


class MMesaageHandlingError(MInternalError):
    pass


class MPluginManagerError(MException):
    """NeoHost framework plugin manager exception."""
    pass


class MCorePluginError(MException):
    """NeoHost framework plugin exception."""
    pass
