#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

import json
from neohost_plugin_ifc import EnumCmdExecMode


class NeoHostRequest(object):
    METHOD = "method"
    MODULE = "module"
    ID = "id"
    EXEC_MODE = "execMode"
    PARAMS = "params"
    API_VER = "apiVer"

    def __init__(self, req_data=None):
        req_data = req_data or {}
        self.module = req_data.get(NeoHostRequest.MODULE)
        self.method = req_data.get(NeoHostRequest.METHOD)
        self.req_id = req_data.get(NeoHostRequest.ID)
        self.params = json.dumps(req_data.get(NeoHostRequest.PARAMS))
        self.exec_mode = req_data.get(NeoHostRequest.EXEC_MODE,
                                      EnumCmdExecMode.Cmd_Exec_Mode_Sync)

    @classmethod
    def get_req_struct(cls):
        req_data = {
            cls.API_VER: "v1",
            cls.ID: "<req_id>",
            cls.EXEC_MODE: "<exec_mode_enum>",
            cls.MODULE: "<module_name>",
            cls.METHOD: "<method_name>",
            cls.PARAMS: "<request_params>"
        }
        return json.dumps(req_data)
