#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

import json


class NeoHostResponse(object):
    ID = "id"
    ERROR = "error"
    RESULT = "result"

    def __init__(self, raw_data=None):
        if not raw_data:
            self.data = {}
        elif isinstance(raw_data, (str, unicode)):
            self.data = json.loads(raw_data)
        else:
            self.data = raw_data
        if NeoHostResponse.ID not in self.data:
            self.data[NeoHostResponse.ID] = 0

    def dump(self):
        return json.dumps(self.data)

    def setID(self, msg_id):
        self.data[NeoHostResponse.ID] = msg_id

    def fromResult(self, rc, res_data):
        for attr_name in (NeoHostResponse.RESULT,
                          NeoHostResponse.ERROR):
            if attr_name in self.data:
                del self.data[attr_name]
        attr_name = NeoHostResponse.RESULT if rc == 0 else \
            NeoHostResponse.ERROR
        if isinstance(res_data, (str, unicode)):
            res_data = json.loads(res_data)
        self.data[attr_name] = res_data

    def getData(self):
        return self.data

    def parse(self):
        req_id = self.data[NeoHostResponse.ID]
        if NeoHostResponse.ERROR in self.data:
            res = self.data[NeoHostResponse.ERROR]
            rc = 1
        else:
            res = self.data[NeoHostResponse.RESULT]
            rc = 0
        return req_id, rc, res

#
#     def serializeResult(self, result, msg_id):
#         self.data = result
#         self.data[NeoHostResponse.ID] = msg_id
#         return self.dump()
#
#     def serializeError(self, error_dict, msg_id):
#         self.data = {
#             NeoHostResponse.ID: msg_id,
#             NeoHostResponse.ERROR: error_dict
#         }
#         return self.dump()
#
#     @classmethod
#     def generateResult(cls, rc, resp_dict):
#         attr_name = cls.RESULT if rc == 0 else cls.ERROR
#         return {
#             attr_name: resp_dict
#         }
