#!/usr/bin/python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

"""
    NeoHost path provider module contains a singleton that contains the path
    to the root directory of NeoHost backend
"""

# Python Imports
import os
# local imports
from common_meta import MSingletonMeta


class MPathProvider(object):
    """Class that provides various filesystem paths relevant for the NeoHost
    framework. Currently holds the root directory."""
    __metaclass__ = MSingletonMeta

    PLUGINS_DIR = "plugins"
    CORE_DIR = "core"

    _ENV_NEOHOST_ROOT_DIR = "NEOHOST_ROOT_DIR"

    def __init__(self):
        root_env = os.environ.get(self._ENV_NEOHOST_ROOT_DIR)
        if root_env and os.path.exists(root_env):
            self.__neohost_root_dir = root_env
        else:
            self.__neohost_root_dir = os.path.dirname(
                os.path.realpath(__file__))
            self.__neohost_root_dir = os.path.join(
                self.__neohost_root_dir, os.pardir, os.pardir)
            self.__neohost_root_dir = os.path.normpath(self.__neohost_root_dir)

    def get_root_dir(self):
        return self.__neohost_root_dir
