# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) 2016-2017, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
'''
Created on Dec 13, 2016

@author: samerd
'''
from neohost_response import NeoHostResponse
import neohost_exceptions
from msg_mgr import MsgMgr, MsgConstants


class PluginCmdAgent(object):
    '''
    agent for executing commands between python plugins
    '''
    def __init__(self, request_handler):
        '''
        Constructor
        '''
        self.request_handler = request_handler
        msg_mgr = MsgMgr()
        msg_mgr.register(MsgConstants.NEOHOST_REQUEST, self.executeCommnd)

    def executeCommnd(self, req_obj):
        try:
            resp_str = self.request_handler.dispatch_request(req_obj)
            resp_obj = NeoHostResponse(resp_str)
        except neohost_exceptions.MException as e:
            resp_obj = NeoHostResponse()
            error_dict = e.to_dict()
            resp_obj.fromResult(1, error_dict)
        except Exception as e:
            # traceback.print_exc()
            exc = neohost_exceptions.NeoHostBaseException(str(e),
                                                          "core")
            error = exc.to_dict()
            resp_obj = NeoHostResponse()
            resp_obj.fromResult(1, error)
        resp_obj.setID(req_obj.req_id)

        return resp_obj.parse()
