# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) 2016-2017, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
'''
Created on Oct 31, 2016

@author: samerd
'''
import threading
import Queue
import uuid


class RequestMgr(object):
    def __init__(self, req_handler):
        self.req_handler = req_handler
        self.th = None
        self.request_queue = Queue.Queue()
        self.response_map = {}

    def _handleRequests(self):
        response = True
        while response is not None:
            req_id, request = self.request_queue.get()
            if request is not None:
                response = self.req_handler.process_request(request)
            else:
                response = None
            self.response_map[req_id].put(response, False)

    def start(self):
        self.th = threading.Thread(target=self._handleRequests)
        self.th.start()

    def stop(self):
        self.requestRecieved(None)

    def requestRecieved(self, request):
        req_id = uuid.uuid4()
        self.response_map[req_id] = Queue.Queue()
        self.request_queue.put((req_id, request), False)
        response = self.response_map[req_id].get()
        del self.response_map[req_id]
        return response
