#!/bin/bash
# Absolute path to this script.
SH_SCRIPT=$(readlink -f $0)
# Absolute parent dir path this script is in.
SCRIPTPATH=$(dirname ${SH_SCRIPT})
pushd ${SCRIPTPATH} > /dev/null 2>&1
PY_SCRIPT=core/pysrc/neohost.py
PYO_SCRIPT="${PY_SCRIPT}o"
PY_EXEC="python"
PY_CMD=""

# Check if arch == ppc64 , export LC_ALL env var
arch=$(uname -p)
if [ "$arch" == "ppc64" ]; then
    export LC_ALL='C'
fi

os=$(uname -s)

PY_EXEC=`find /usr/bin /bin/ /usr/local/bin -iname 'python*' 2>&1 | grep -e='*python[0-9,.]*' | sort -d | head -n 1`
if [[ ${PY_EXEC} == *"python3"* ]]; then
    echo "Python 3 not supported"
    echo "Supported Python version: 2.x from version 2.6 and above"
    popd > /dev/null 2>&1
    exit 1
else
    which python2 >/dev/null 2>&1
    if test $? -eq 0 ; then
       PY_EXEC='/usr/bin/env python2'
    fi
fi

if [[ -f ${PY_SCRIPT} ]]; then
    PY_CMD="${PY_EXEC}  -u ${PY_SCRIPT} --development"
elif [[ -f ${PYO_SCRIPT} ]]; then
    PY_CMD="${PY_EXEC} -u -O ${PYO_SCRIPT}"
else
    echo "Could not find file: ${PY_SCRIPT}"
    popd > /dev/null 2>&1
    exit 1
fi

${PY_CMD} "$@"
popd > /dev/null 2>&1
