#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Ariel Gaisinsky
# @date: Aug 12, 2017


from common_meta import MEnumMeta


class ConfigFlowsDefs:
    FW_MIN_VERSION = "18.1000"
    OFED_MIN_VERSION = "4.2"
    WINOF_MIN_VERSION = "2.0.19750.0"

    CONFIG_FLOWS_PLUGIN_NAME = "configFlows"
    CONFIG_FLOWS_PLUGIN_DESC = "configuration flows python plugin"
    CONFIG_FLOWS_PLUGIN_VER = (1, 0)

    CONFIG_FLOWS_STATUS_SUCCESS = 0
    CONFIG_FLOWS_STATUS_FAILURE = 1

    ROCE_SUCCESS_MSG = "ROCE configuration applied successfully. Please make sure the switch configured accordingly."
    ROCE_SUCCESS_CLEANUP_MSG = "Pre-configured state applied successfully."
    ROCE_VALIDATION_FAIL_REASON = "-%s- command returned: %s. expecting %s"

    ROCE_DEFAULT_DSCP_VAL = 26

class RoCEConfigType(object):
    __metaclass__ = MEnumMeta
    NoRoCEConfiguration = 0
    RoCEWithoutQos = 1
    RoCEWithQos = 2
    LosslessRoCEWithQos = 3