#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Samer Deeb
# @date: Dec 12, 2016

import neohost_plugin_ifc
from config_flows_defs import ConfigFlowsDefs
from set_device_sriov_linux import SetDeviceSRIOVLinux
from set_device_sriov_windows import SetDeviceSRIOVWindows
from set_device_roce_linux import SetDeviceRoCELinux
from set_device_roce_windows import SetDeviceRoCEWindows
from get_device_roce_validation_windows import GetDeviceRoCEValidationWindows
from set_device_roce_cleanup_linux import SetDeviceRoCECleanupLinux
from set_device_roce_cleanup_windows import SetDeviceRoCECleanupWindows
from get_device_roce_validation_linux import GetDeviceRoCEValidationLinux
from get_device_sriov_state_linux import GetDeviceSRIOVStateLinux
from get_device_roce_state_linux import GetDeviceRoCEStateLinux
from get_device_roce_state_windows import GetDeviceRoCEStateWindows
from neohost_common import NeoHostCommon


class ConfigFlowsPlugin(neohost_plugin_ifc.AbsNeoHostPluginIFC):
    def __init__(self):
        super(ConfigFlowsPlugin, self).__init__(
            ConfigFlowsDefs.CONFIG_FLOWS_PLUGIN_NAME,
            ConfigFlowsDefs.CONFIG_FLOWS_PLUGIN_DESC,
            ConfigFlowsDefs.CONFIG_FLOWS_PLUGIN_VER)
        if NeoHostCommon.isWindowsOs():
            self.add_command(SetDeviceRoCEWindows())
            self.add_command(SetDeviceRoCECleanupWindows())
            self.add_command(GetDeviceRoCEValidationWindows())
            self.add_command(SetDeviceSRIOVWindows())
            self.add_command(GetDeviceRoCEStateWindows())
        elif not NeoHostCommon.isFreebsdOs():
            self.add_command(SetDeviceRoCELinux())
            self.add_command(SetDeviceRoCECleanupLinux())
            self.add_command(GetDeviceRoCEValidationLinux())
            self.add_command(SetDeviceSRIOVLinux())
            self.add_command(GetDeviceSRIOVStateLinux())
            self.add_command(GetDeviceRoCEStateLinux())