#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Ariel Gaisinsky
# @date: Dec 13, 2017


import json
import logging

from cmd_exec import Command
from config_flows_defs import RoCEConfigType
from config_flows_defs import ConfigFlowsDefs
from config_flows_exceptions import ConfigFlowsException
import neohost_plugin_ifc as APIFC
from config_flows_common import ConfigFlowsCommon
from neohost_common import NeoHostCommon


class GetDeviceRoCEState(APIFC.AbsNeoHostCommandIFC):
    logger = logging.getLogger("neohost." + __name__)

    def __init__(self):
        super(GetDeviceRoCEState, self).__init__(
            cmd_name="GetDeviceRoCEState",
            cmd_desc="Get RoCE state",
            cmd_type=APIFC.EnumCmdType.Cmd_Type_Set,
            cmd_scope=APIFC.EnumCmdScope.Cmd_Scope_Device,
            supp_exec_mask=APIFC.EnumCmdExecMode.Cmd_Exec_Mode_All,
            cmd_in_desc="ifcUid: interface uid ",
            cmd_out_desc="msgText: message text, msgCode: message code, configType: int configuration type, "
            "dscpVal: dscp val",
            extra_str="")


    def execute_command(self, json_request, exec_opt):
        req = json.loads(json_request)
        ifc_id = req["ifcUid"]

        res = self._getRoceState(ifc_id)
        return ConfigFlowsDefs.CONFIG_FLOWS_STATUS_SUCCESS, json.dumps(res)


    def _getRoceState(self, ifc_id):
        err_msg = "GetDeviceRoCEState is an abstract class, you can't create an instance."
        GetDeviceRoCEState.logger.error(err_msg)
        raise ConfigFlowsException(err_msg)
