#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Ariel Gaisinsky
# @date: Jan 30, 2018


from get_device_roce_state import GetDeviceRoCEState
from roce_windows_common import RoCEWindowsCommon
from config_flows_exceptions import ConfigFlowsException
from config_flows_common import ConfigFlowsCommon


class GetDeviceRoCEStateWindows(GetDeviceRoCEState):
    def __init__(self):
        super(GetDeviceRoCEStateWindows, self).__init__()

    def _getRoceState(self, ifc_id):
        # check if Mellanox adapter
        if not ConfigFlowsCommon.checkIfMellanoxAdapter(ifc_id, GetDeviceRoCEStateWindows.logger):
            raise ConfigFlowsException("Adapter %s is unknown or not a Mellanox adapter." % ifc_id)

        RoCEWindowsCommon.checkInstallDataCenterBridging(GetDeviceRoCEStateWindows.logger)

        config_type, dscp_Val = RoCEWindowsCommon.getRoCEStatusQuery(ifc_id,
                                                                     GetDeviceRoCEStateWindows.logger)

        res = {
            "configType": config_type,
            "dscpVal": dscp_Val
        }
        return res
