#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Ariel Gaisinsky
# @date: Jan 30, 2018


from get_device_roce_validation import GetDeviceRoCEValidation
from roce_windows_common import RoCEWindowsCommon
from config_flows_common import ConfigFlowsCommon
from config_flows_exceptions import ConfigFlowsException


class GetDeviceRoCEValidationWindows(GetDeviceRoCEValidation):
    def __init__(self):
        super(GetDeviceRoCEValidationWindows, self).__init__()

    def _runRoceValidation(self, ifc_id, req_config_type, req_dscp_val):
        #check if Mellanox adapter
        if not ConfigFlowsCommon.checkIfMellanoxAdapter(ifc_id, GetDeviceRoCEValidationWindows.logger):
            raise ConfigFlowsException("Adapter %s is unknown or not a Mellanox adapter." % ifc_id)

        RoCEWindowsCommon.checkInstallDataCenterBridging(GetDeviceRoCEValidationWindows.logger)

        config_type, dscp_Val = RoCEWindowsCommon.getRoCEStatusQuery(ifc_id,
                                                                     GetDeviceRoCEValidationWindows.logger)
        
        if RoCEWindowsCommon.isLossy(config_type):
            if config_type == req_config_type:
                is_valid = True
            else:
                is_valid = False
        else:
            if config_type == req_config_type:
                if int(dscp_Val) == req_dscp_val:
                    is_valid = True
                else: 
                    is_valid = False
            else: 
                    is_valid = False

        cur_config = ""
        if not is_valid:
            config_type_str = RoCEWindowsCommon.getRoCEConfigNameByType(config_type)
            cur_config = "Current RoCE configuration is %s with DSCP %s." % (config_type_str, dscp_Val)

        res = {
            "msgCode": 0,
            "msgText": "RoCE validation result: %s. %s" % (is_valid, cur_config),
            "roceValid": is_valid
        }
        return res


