#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Ariel Gaisinsky
# @date: Jan 30, 2018

from config_flows_common import ConfigFlowsCommon
from get_device_sriov_state import GetDeviceSRIOVState
from sriov_common import SRIOVCommon


class GetDeviceSRIOVStateLinux(GetDeviceSRIOVState):
    def __init__(self):
        super(GetDeviceSRIOVStateLinux, self).__init__()


    def _getSriovState(self, dev_uid, ifcs_list):
        fw_num_vfs, fw_enable_sriov = SRIOVCommon.getCurFwSriovConfig(dev_uid)
        res = {
            "fwNumVFs": fw_num_vfs,
            "fwSriovEnabled": fw_enable_sriov,
            "ifcsState": []
        }

        for ifc_uid in ifcs_list:
            num_vfs, sriov_enabled = self._getInterfaceSriovState(ifc_uid)
            item = {"ifcUid": ifc_uid, "numVFs": num_vfs, "sriovEnabled": sriov_enabled}
            res["ifcsState"].append(item)

        return res


    def _getInterfaceSriovState(self, ifc_uid):
        if ConfigFlowsCommon.isEthernetInterface(ifc_uid):
            file = "/sys/class/net/%s/device/mlx5_num_vfs" % ifc_uid
        else:
            ifc_rdma = ConfigFlowsCommon.convertInterfaceToMlxDev(ifc_uid)
            file = "/sys/class/infiniband/%s/device/mlx5_num_vfs" % ifc_rdma

        cmd = "cat %s" % file
        failMsg = "Failed to get interface %s, SRIOV configuration could not find file %s. " \
                  "make sure that SRIOV is enabled on BIOS and the interface is up" % (ifc_uid, file)
        vfs = int(ConfigFlowsCommon.commandExecute(cmd, failMsg).strip())
        sriov_enabled = False if vfs == 0 else True
        return vfs, sriov_enabled


    def _checkPrerequisites(self, ifcs):
        pass
