#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Ariel Gaisinsky
# @date: May 21, 2018

from cmd_exec import Command
from config_flows_common import ConfigFlowsCommon
from config_flows_defs import RoCEConfigType


class RoCEWindowsCommon:
    @classmethod
    def checkInstallDataCenterBridging(cls, logger):
        cmd = 'powershell -command Get-NetQosFlowControl'
        rc, out, _ = Command(cmd).execute()
        if rc:
            cmd = 'Install-WindowsFeature \"data-center-bridging\"'
            ConfigFlowsCommon.powerShellCommandExec(cmd, logger)


    @classmethod
    def convertConfigStrToType(cls, config_type_str):
        config_type = RoCEConfigType.RoCEWithoutQos
        if config_type_str.startswith("Lossy fabric with QoS"):
            config_type = RoCEConfigType.RoCEWithQos
        elif config_type_str.startswith("Lossless fabric"):
            config_type = RoCEConfigType.LosslessRoCEWithQos
        return config_type


    @classmethod
    def getRoCEStatusQuery(cls, adapter_name, logger):
        cmd = 'Mlx5Cmd.exe -QoSConfig -Name \"%s\" -SetupRoceQosConfig -Query' % adapter_name
        logger.info("Get RoCE status: %s" % cmd)
        out = ConfigFlowsCommon.commandExecute(cmd, failMsg=None, raiseExcept=False)
        logger.info("Query output: %s" % out)

        tmp_str = out.replace("Data-Center-Bridging is installed", "").strip()
        tmp_str = tmp_str.replace("Current configuration is:", "").strip()

        if (tmp_str == "RoceQos is not configured properly."):
            return 0, -1

        str_parts = tmp_str.split("with Dscp Value")
        dscp_Val = -1
        if len(str_parts) > 0:
            config_type_str = str_parts[0]
        if len(str_parts) == 2:
            dscp_Val = int((str_parts[1].strip()).split(' ', 1)[0])

        config_type = RoCEWindowsCommon.convertConfigStrToType(config_type_str)
        return config_type, dscp_Val


    @classmethod
    def getRoCEConfigNameByType(cls, config_type):
        if config_type == RoCEConfigType.LosslessRoCEWithQos:
            return "Lossless fabric"
        elif config_type == RoCEConfigType.RoCEWithQos:
            return "Lossy fabric with QoS"
        else:
            return "Lossy fabric"
        
    @classmethod
    def isLossy(cls, config_type):
        if config_type == RoCEConfigType.LosslessRoCEWithQos:
            return False 
        elif config_type == RoCEConfigType.RoCEWithQos: 
            return False 
        else:
            return True
