#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Ariel Gaisinsky
# @date: Aug 20, 2017


import json
import logging

from config_flows_defs import RoCEConfigType
from config_flows_defs import ConfigFlowsDefs
from config_flows_exceptions import ConfigFlowsException
import neohost_plugin_ifc as APIFC
from config_flows_common import ConfigFlowsCommon
from request_factory import RequestFactory
from msg_mgr import MsgMgr, MsgConstants




class SetDeviceRoCE(APIFC.AbsNeoHostCommandIFC):
    logger = logging.getLogger("neohost." + __name__)

    def __init__(self):
        super(SetDeviceRoCE, self).__init__(
            cmd_name="SetDeviceRoCE",
            cmd_desc="Set RoCE configuration on device",
            cmd_type=APIFC.EnumCmdType.Cmd_Type_Set,
            cmd_scope=APIFC.EnumCmdScope.Cmd_Scope_Device,
            supp_exec_mask=APIFC.EnumCmdExecMode.Cmd_Exec_Mode_All,
            cmd_in_desc="devUid: device uid, ifcUid: interface uid "
            "configType: Without Qos=1 / With Qos=2 / Lossless with Qos=3",
            cmd_out_desc="msgText: message text, msgCode: message code",
            extra_str="")


    def execute_command(self, json_request, exec_opt):
        req = json.loads(json_request)
        res = {
            "msgCode": 0,
            "msgText": ConfigFlowsDefs.ROCE_SUCCESS_MSG
        }

        ifc_id = req["ifcUid"]
        config_type = RoCEConfigType.RoCEWithoutQos
        dscp_val = ConfigFlowsDefs.ROCE_DEFAULT_DSCP_VAL
        force = False

        if "configType" in req:
            config_type = req["configType"]
        if "configModifier" in req:
            adv_params = req["configModifier"]
            if "dscpVal" in adv_params:
                dscp_val = adv_params["dscpVal"]
            if "force" in adv_params:
                force = adv_params["force"]

        self._runConfigureCommand(config_type, ifc_id, dscp_val, force)

        return ConfigFlowsDefs.CONFIG_FLOWS_STATUS_SUCCESS, json.dumps(res)


    def _runConfigureCommand(self, config_type, ifc_id, dscp_val, force):
        raise ConfigFlowsException("SetDeviceRoCE is an abstract class, you can't create an instance.")


    def _cleanConfiguration(self, ifc_id):
        config_params = {
            "ifcUid": ifc_id,
        }
        sub_req_obj = RequestFactory.createRequest(1,
                                                   "configFlows",
                                                   "SetDeviceRoCECleanup",
                                                   config_params)
        _, rc, response = MsgMgr().handle(MsgConstants.NEOHOST_REQUEST,
                                          sub_req_obj)
        if rc != 0:
            raise ConfigFlowsException("Failed to cleanup RoCE configuration: %s" %
                                       response["message"])