#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Ariel Gaisinsky
# @date: Dec 7, 2017


import json
import logging

from config_flows_defs import ConfigFlowsDefs
import neohost_plugin_ifc as APIFC
from config_flows_exceptions import ConfigFlowsException
from config_flows_common import ConfigFlowsCommon
from neohost_common import NeoHostCommon


class SetDeviceRoCECleanup(APIFC.AbsNeoHostCommandIFC):
    logger = logging.getLogger("neohost." + __name__)

    def __init__(self):
        super(SetDeviceRoCECleanup, self).__init__(
            cmd_name="SetDeviceRoCECleanup",
            cmd_desc="Set RoCE configuration on device",
            cmd_type=APIFC.EnumCmdType.Cmd_Type_Set,
            cmd_scope=APIFC.EnumCmdScope.Cmd_Scope_Device,
            supp_exec_mask=APIFC.EnumCmdExecMode.Cmd_Exec_Mode_All,
            cmd_in_desc="devUid: device uid, ifcUid: interface uid "
            "configType: Without Qos=1 / With Qos=2 / Lossless with Qos=3",
            cmd_out_desc="msgText: message text, msgCode: message code",
            extra_str="")

    def execute_command(self, json_request, exec_opt):
        req = json.loads(json_request)

        ifc_id = req["ifcUid"]

        res = {
            "msgCode": 0,
            "msgText": ConfigFlowsDefs.ROCE_SUCCESS_CLEANUP_MSG
        }

        ConfigFlowsCommon.checkDriverVersion(SetDeviceRoCECleanup.logger)
        if not NeoHostCommon.isWindowsOs():
		    ConfigFlowsCommon.checkOfedStarted(SetDeviceRoCECleanup.logger)

        self._setRoceCleanup(ifc_id)

        return ConfigFlowsDefs.CONFIG_FLOWS_STATUS_SUCCESS, json.dumps(res)


    def _setRoceCleanup(self, ifc_id):
        raise ConfigFlowsException("SetDeviceRoCECleanup is an abstract class, you can't create an instance.")

