#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Ariel Gaisinsky
# @date: Dec 7, 2017


import json
import logging

from config_flows_defs import ConfigFlowsDefs
import neohost_plugin_ifc as APIFC
from config_flows_common import ConfigFlowsCommon
from neohost_common import NeoHostCommon
from config_flows_exceptions import ConfigFlowsException
from set_device_roce_cleanup import SetDeviceRoCECleanup


class SetDeviceRoCECleanupLinux(SetDeviceRoCECleanup):
    def __init__(self):
        super(SetDeviceRoCECleanupLinux, self).__init__()


    def _setRoceCleanup(self, ifc_id):
        #checks
        ConfigFlowsCommon.checkInterfaceExist(ifc_id, SetDeviceRoCECleanupLinux.logger)
        ConfigFlowsCommon.checkIfIfcEthernet(ifc_id, SetDeviceRoCECleanupLinux.logger)

        mlx_dev_name = ConfigFlowsCommon.convertInterfaceToMlxDev(ifc_id)
        ConfigFlowsCommon.checkFWVersion(mlx_dev_name, SetDeviceRoCECleanupLinux.logger)

        self.__resetDscpAsTrust(ifc_id)
        self.__disableECN()
        self.__resetTos(mlx_dev_name)
        self.__disablePFC(ifc_id)
        self.__resetRDMACMTos(mlx_dev_name)


    def __disableECN(self):
        SetDeviceRoCECleanupLinux.logger.debug("__disableECN")
        cmd = "sysctl -w net.ipv4.tcp_ecn=1"
        fail_msg = "Failed To disable ECN."
        ConfigFlowsCommon.commandExecute(cmd, fail_msg)


    def __resetRDMACMTos(self, mlx_dev):
        SetDeviceRoCECleanupLinux.logger.debug("__resetTos")
        cmd = "cma_roce_tos -d %s -t 0" % mlx_dev
        fail_msg = "Failed to reset Tos. Command -%s- has failed" % cmd
        ConfigFlowsCommon.commandExecute(cmd, fail_msg)


    def __resetTos(self, mlx_dev):
        SetDeviceRoCECleanupLinux.logger.debug("__resetTos")
        cmd = "echo %d > /sys/class/infiniband/%s/tc/1/traffic_class" % (-1, mlx_dev)
        fail_msg = "Failed to reset RDMA-CM Tos. Command -%s- has failed" % cmd
        ConfigFlowsCommon.commandExecute(cmd, fail_msg)


    def __resetDscpAsTrust(self, ifc_id):
        """this commands resets dscp2prio mapping as well 
        by switching back and forth between pcp and dscp trust"""

        SetDeviceRoCECleanupLinux.logger.debug("__setDscpAsTrust")
        cmd_pcp = "mlnx_qos -i %s --trust pcp" % ifc_id
        cmd_dscp = "mlnx_qos -i %s --trust dscp" % ifc_id
        fail_msg = "Failed to reset trust"
        ConfigFlowsCommon.commandExecute(cmd_pcp, fail_msg)
        ConfigFlowsCommon.commandExecute(cmd_dscp, fail_msg)
        ConfigFlowsCommon.commandExecute(cmd_pcp, fail_msg)


    def __disablePFC(self, ifc_id):
        SetDeviceRoCECleanupLinux.logger.debug("__disablePFC")
        cmd = "mlnx_qos -i %s --pfc 0,0,0,0,0,0,0,0 " % ifc_id
        fail_msg = "Failed to disable PFC"
        ConfigFlowsCommon.commandExecute(cmd, fail_msg)
