#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Ariel Gaisinsky
# @date: Dec 7, 2017

from config_flows_common import ConfigFlowsCommon
from set_device_roce_cleanup import SetDeviceRoCECleanup
from roce_windows_common import RoCEWindowsCommon
from config_flows_exceptions import ConfigFlowsException


class SetDeviceRoCECleanupWindows(SetDeviceRoCECleanup):
    def __init__(self):
        super(SetDeviceRoCECleanupWindows, self).__init__()

    def _setRoceCleanup(self, adapter_name):
        if not ConfigFlowsCommon.checkIfMellanoxAdapter(adapter_name, SetDeviceRoCECleanupWindows.logger):
            raise ConfigFlowsException("Adapter %s is unknown or not a Mellanox adapter." % adapter_name)

        # install data center bridging
        RoCEWindowsCommon.checkInstallDataCenterBridging(SetDeviceRoCECleanupWindows.logger)

        cmd = 'Mlx5Cmd.exe -QoSConfig -Name \"%s\" -SetupRoceQosConfig -Configure \"%s\"' % \
              (adapter_name, 0)
        SetDeviceRoCECleanupWindows.logger.info("setting RoCE cleanup with command: %s" % cmd)
        ConfigFlowsCommon.commandExecute(cmd)
