#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Ariel Gaisinsky
# @date: Jan 30, 2017

from config_flows_common import ConfigFlowsCommon
from set_device_roce import SetDeviceRoCE
from roce_windows_common import RoCEWindowsCommon
from config_flows_exceptions import ConfigFlowsException


class SetDeviceRoCEWindows(SetDeviceRoCE):
    def __init__(self):
        super(SetDeviceRoCEWindows, self).__init__()


    def _runConfigureCommand(self, config_type, ifc_id, dscp_val, force):
        if not ConfigFlowsCommon.checkIfMellanoxAdapter(ifc_id, SetDeviceRoCEWindows.logger):
            raise ConfigFlowsException("Adapter %s is unknown or not a Mellanox adapter." % ifc_id)

        ConfigFlowsCommon.checkDriverVersion(SetDeviceRoCEWindows.logger)

        # install data center bridging
        RoCEWindowsCommon.checkInstallDataCenterBridging(SetDeviceRoCEWindows.logger)

        cmd = 'Mlx5Cmd.exe -QoSConfig -Name \"%s\" -SetupRoceQosConfig -Configure \"%s\" -Dscp \"%s\"' % \
                (ifc_id, config_type-1, dscp_val)
        SetDeviceRoCEWindows.logger.info("setting RoCE configuration with command: %s" % cmd)
        ConfigFlowsCommon.commandExecute(cmd)
