#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Samer Deeb
# @date: Dec 12, 2016

import os
from config_flows_common import ConfigFlowsCommon
from set_device_sriov import SetDeviceSRIOV
from sriov_common import SRIOVCommon


class SetDeviceSRIOVLinux(SetDeviceSRIOV):
    def __init__(self):
        super(SetDeviceSRIOVLinux, self).__init__()


    def __configureDriverNumVFs(self, vfs_config_map, overwrite_with_zero=False):
        ### changing num of vfs in driver configration file

        # overwrite with 0 the num_of_vfs for all ifc_uid in the list
        if overwrite_with_zero:
            for ifc_uid in vfs_config_map.keys():
                vfs_config_map[ifc_uid] = 0

        for ifc_uid, num_vfs in vfs_config_map.iteritems():
            if ConfigFlowsCommon.isEthernetInterface(ifc_uid):
                file = "/sys/class/net/%s/device/mlx5_num_vfs" % ifc_uid
            else:
                ifc_rdma = ConfigFlowsCommon.convertInterfaceToMlxDev(ifc_uid)
                file = "/sys/class/infiniband/%s/device/mlx5_num_vfs" % ifc_rdma

            if not os.path.exists(file):
                raise ConfigFlowsCommon.raiseException("SRIOV configuration: File %s does not exist" % file)

            # to change the value first put 0 value first
            cmd = "echo 0 > %s" % file
            failMsg = "Failed to configure interface %s. make sure that SRIOV is enabled on BIOS and the interface is up" % (ifc_uid)
            ConfigFlowsCommon.commandExecute(cmd, failMsg)

            if num_vfs > 0 :
                cmd = "echo %s > %s" % (num_vfs, file)
                failMsg = "Failed to configure interface %s. make sure that SRIOV is enabled on BIOS and the interface is up" % (ifc_uid)
                ConfigFlowsCommon.commandExecute(cmd, failMsg)


    def _enableSriov(self, dev_uid, vfs_config_map, max_vfs, updateFw):
        curr_num_vfs, curr_enable_sriov = SRIOVCommon.getCurFwSriovConfig(dev_uid)

        # if user asked more num of vfs them current and no used update_fw flag with true
        if curr_num_vfs < max_vfs and not updateFw:
            res = {
                "msgCode": 2,
                "msgText": "Failed to configure SRIOV: Num_oF_VFS requested is grater than the current if the FW. "
                "To update it please use the updateFw flag with True."
            }
            return res

        if not curr_enable_sriov or curr_num_vfs < max_vfs:
            # no meaning for updateFw - will aenable Sriov in FW anyway
            self._configureDevice(dev_uid, max_vfs, "True")
            res = {
                "msgCode": 1,
                "msgText": "Further operation needed, you have to reboot "
                           "for the changes to take effect, "
                           "after that please rerun the command "
                           "again to configuring the interface"
            }
            return res

        # set num of vafs in the driver files by user request
        self.__configureDriverNumVFs(vfs_config_map)

        res = {
            "msgCode": 0,
            "msgText": "Success"
        }
        return res


    def _disableSriov(self, dev_uid, vfs_config_map, updateFw):
        res = {
            "msgCode": 0,
            "msgText": "Success"
        }

        # set num of vafs to 0 in the driver files
        self.__configureDriverNumVFs(vfs_config_map, True)

        # only if user used updateFw attr with True
        if updateFw:
            curr_num_vfs, curr_enable_sriov = SRIOVCommon.getCurFwSriovConfig(dev_uid)

            # in case of disable - we DON'T change the NUM_OF_VFS number in the FW to 0
            if curr_enable_sriov:
                self._configureDevice(dev_uid, None, "False")
                res["msgCode"] = 2
                res["msgText"] = "Operation succeeded. However, you need to reboot " \
                               "in order to complete the changes in the device FW, " \
                               "and then run the operation again"

        return res


    def _checkPrerequisites(self, ifcs):
        pass
        # path1 = "/boot/grub/grub.conf"
        # path2 = "/boot/grub2/grub.cfg"
        #
        # if os.path.exists(path1):
        #     path = path1
        # elif os.path.exists(path2):
        #     path = path2
        # else:
        #     raise ConfigFlowsException(
        #         "SRIOV configuration prerequisites issue: cannot find grub config file.")
        #
        # cmd = " cat %s | grep intel_iommu" % path
        # failMsg = "SRIOV configuration prerequisites issue:" \
        #           "unable to find -intel_iommu- attribute in grub config file."
        # out = ConfigFlowsCommon.commandExecute(cmd, failMsg)
        #
        # out_parts = out.split(' ')
        # found = False
        # for word in out_parts:
        #     if word.startswith("intel_iommu"):
        #         word_parts = word.split("=")
        #         if len(word_parts) == 2:
        #             if word_parts[1] != "on":
        #                 raise ConfigFlowsException(
        #                     "SRIOV configuration prerequisites issue:" \
        #                     " -intel_iommu- attribute not set to on in grub config file.")
        #
        #             found = True
        #         else:
        #             raise ConfigFlowsException(
        #                 "SRIOV configuration prerequisites issue:" \
        #                 " -intel_iommu- attribute in grub config file is unknows.")
        #         break
        #
        # if not found:
        #     raise ConfigFlowsException("SRIOV configuration prerequisites issue:" \
        #         "cannot find \"intel_iommu\" attribute in grub config file.")

