#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Ariel Gaisinsky
# @date: May 17, 2018


from config_flows_exceptions import ConfigFlowsException
from request_factory import RequestFactory
from msg_mgr import MsgMgr, MsgConstants


class SRIOVCommon:
    @classmethod
    def getCurFwSriovConfig(self, devUid):
        ### return the current configuration values for SRIOV_EN and NUM_OF_VFS
        configName = "GLOBAL PCI CONF"
        configMode = 2

        config_params = {
            "devUid": devUid,
            "configName": configName,
            "configMode": configMode,
        }
        sub_req_obj = RequestFactory.createRequest(
            1, "mftConfig", "GetDeviceNVConfig", config_params)
        _, rc, response = MsgMgr().handle(
            MsgConstants.NEOHOST_REQUEST, sub_req_obj)
        if rc != 0:
            raise ConfigFlowsException(
                "Failed to get device %s configuration: %s" %
                (devUid, response["message"]))
        pci_config = response[0]
        paramsList = pci_config.get("paramsList")
        num_vfs = -1
        enable_sriov = None
        if paramsList:
            for param in paramsList:
                if param["paramName"] == "NUM_OF_VFS":
                    num_vfs = int(param["paramVal"])
                elif param["paramName"] == "SRIOV_EN":
                    enable_str = param["paramVal"]
                    if enable_str == "True":
                        enable_sriov = True
                    else:
                        enable_sriov = False

        if num_vfs < 0:
            raise ConfigFlowsException("Failed to Get SR-IOV -NUM_OF_VFS- configuration.")
        if enable_sriov == None:
            raise ConfigFlowsException("Failed to Get SR-IOV -SRIOV_EN- configuration.")

        return num_vfs, enable_sriov
