# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# Python Imports
from cmd_exec import Command
import mft_core_exceptions


class CommonHelpFuncs:
    @classmethod
    def getNameByPCIDeviceId(self, pciId):
        dev_name = ""
        cmd = "mst status -v"
        rc, out, _ = Command(cmd).execute()
        if not rc:
            lines = out.splitlines()
            for line in lines:
                if line.find(pciId) != -1:
                    dev_name = line
        return dev_name


    @classmethod
    def powerShellCommandExec(self, cmd):
        pshell_cmd = 'powershell -command "%s"' % cmd
        rc, out, err = Command(pshell_cmd).execute()
        return rc, out, err


    @classmethod
    def printToLogAndRaiseMftCoreException(self, msg, logger):
        logger.error(msg)
        raise mft_core_exceptions.MftCoreException(msg)