#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# Python Imports
import json
import logging
import sys
# NeoHost IFC Imports
import neohost_plugin_ifc as APIFC
from cmd_exec import Command
import json_entry_creator
# Plugin Imports
import mft_core_exceptions
from mft_core_defs import MftCoreDefs
import os
from common_help_funcs import CommonHelpFuncs
from neohost_common import NeoHostCommon

class GetPortInfoCommand(APIFC.AbsNeoHostCommandIFC):
    logger = logging.getLogger("neohost." + __name__)

    GENERAL_PORT_ATTR = {
        "portInfo": ("Port Information", "Various port information.")
    }

    def __init__(self):
        super(GetPortInfoCommand, self).__init__(
            cmd_name="GetPortInfo",
            cmd_desc="get various port information",
            cmd_type=APIFC.EnumCmdType.Cmd_Type_Get,
            cmd_scope=APIFC.EnumCmdScope.Cmd_Scope_Port,
            supp_exec_mask=APIFC.EnumCmdExecMode.Cmd_Exec_Mode_All,
            cmd_in_desc="portUid: port identifier, attrMask: attribute mask",
            cmd_out_desc="various port information",
            extra_str="")


    def execute_command(self, json_request, exec_opt):
        GetPortInfoCommand.logger.info("Executing GetPortInfo command..")
        req = json.loads(json_request)
        att_mask = None
        if "attrMask" in req:
            att_mask = req["attrMask"]
        portUid = req["portUid"]

        entry_creator = json_entry_creator.InfoEntryCreator()

        if att_mask:
            entry_creator.set_attr_mask(req["attrMask"])

        result_dict = self._getPortInfo(portUid, entry_creator)

        attr_name = "portInfo"
        attr_disp, attr_desc = self.GENERAL_PORT_ATTR.get(attr_name)
        final_result = dict()
        final_result[attr_name] = entry_creator.create_entry(
            attr_disp, result_dict, attr_desc, 0)

        GetPortInfoCommand.logger.info("finished executing GetPortInfo command.")
        return MftCoreDefs.MFT_CORE_STATUS_SUCCESS, json.dumps(final_result)


    def _getPortInfo(self, portUid, entry_creator):
        CommonHelpFuncs.printToLogAndRaiseMftCoreException(
                            "Error: GetPortInfoCommand is Abstract class.",
                            GetPortInfoCommand.logger)


