#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# Python Imports
import json
import sys
from cmd_exec import Command
import json_entry_creator
# Plugin Imports
import mft_core_exceptions
from mft_core_defs import MftCoreDefs
import os
from common_help_funcs import CommonHelpFuncs
from neohost_common import NeoHostCommon
from get_port_info import GetPortInfoCommand


class GetPortInfoCommandWindows(GetPortInfoCommand):

    PORT_ATTR_MAPPING = {
        "name": ("name", "Adapter Name", "Adapter name.", None),
        "state": ("state", "Link State",
                  "Port state (affected by the active subnet manager).",
                  None),
        "port_guid": ("portGuid", "Port GUID", "GUID assigned to the port.",
                      None),
        "node_guid": ("nodeGuid", "Node GUID", "GUID assigned to the node.",
                      None),
        "port_state": ("portState", "Port State",
                           "Port state.", None),
        "port_phys_state": ("portPhysState", "Physical State",
                           "Port physical state.", None),
        "link_speed": ("linkSpeed", "Link Speed", "link Speed in Gb/s.", None),
        "active_mtu": ("activeMtu", "Active MTU", "Active MTU.", None),
        "link_layer": ("linkLayer", "Link Layer",
                       "Current port Link Layer configuration.", None),
    }


    def __init__(self):
        super(GetPortInfoCommandWindows, self).__init__()


    def _getPortInfo(self, portUid, entry_creator):
        result_dict = dict()
        port_info_dict_lower = dict()
        local_idx = 0

        port_info_dict = self.__getPortWindowsData(portUid)
        # temp solution because of Winof mlx5cmd bug
        for key, val in port_info_dict.iteritems():
            new_key = key[0].lower() + key[1:]
            port_info_dict_lower[new_key] = val

        for port_info_attr, (attr_name, attr_disp, attr_desc, cast) in\
                self.PORT_ATTR_MAPPING.iteritems():
            if port_info_attr in port_info_dict_lower.keys():
                val = port_info_dict_lower[port_info_attr].strip()
            else:
                val = "N/A"
            result_dict[attr_name] = entry_creator.create_entry(
                attr_disp, val, attr_desc, local_idx)
            local_idx += 1
        return result_dict


    def __getPortWindowsData(self, portUid):
        cmd = "Mlx5Cmd.exe -stat -json"
        rc, out, err = Command(cmd).execute()
        if rc:
            CommonHelpFuncs.printToLogAndRaiseMftCoreException(
                    "Could not get port information.",
                    GetPortInfoCommandWindows.logger)

        res = json.loads(out)
        for nic_info in res.values():
            try:
                # get pci of NIC 1/2
                phy_location = nic_info["Info"]["physical_location"]
                pci_parts_str = phy_location.split(',')
                bus = -1
                device = -1
                for part in pci_parts_str:
                    part = part.strip()
                    if part.startswith('Bus'):
                        bus = part.replace('Bus ', '')
                    elif part.startswith('Device'):
                        device = part.replace('Device ', '')
                if bus == -1 or device == -1:
                    CommonHelpFuncs.printToLogAndRaiseMftCoreException(
                            "UnKnown physical location",
                            GetPortInfoCommandWindows.logger)

                # get pci from req
                port_parts = portUid.split(':')
                if len(port_parts) == 3:
                    del port_parts[0]
                if len(port_parts) != 2:
                    CommonHelpFuncs.printToLogAndRaiseMftCoreException(
                        "Could not parse poir uid",
                        GetPortInfoCommandWindows.logger)

                port_bus = int(port_parts[0], 16)
                port_other_parts = port_parts[1].split('.')
                if len(port_other_parts) != 2:
                    CommonHelpFuncs.printToLogAndRaiseMftCoreException(
                        "Could not parse poir uid",
                        GetPortInfoCommandWindows.logger)
                port_device = int(port_other_parts[0], 16)
                port_func = int(port_other_parts[1], 16)

                # compare pci from req with structure pci
                if port_bus == int(bus) and port_device == int(device):
                    for adapter_info in nic_info["Adapters"].values():
                        if adapter_info["physical_location"]["Function"] == str(port_func):
                            return adapter_info
                    break
            except:
                CommonHelpFuncs.printToLogAndRaiseMftCoreException(
                                    "UnKnown physical location",
                                    GetPortInfoCommandWindows.logger)

