#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# Python Imports
try:
    import sys
    import neohost_plugin_ifc
    from get_server_info import GetSystemServerInfoCommand
    from get_ifc_info import GetInterfaceInfoCommand
    from mft_core_defs import MftCoreDefs
    from neohost_common import NeoHostCommon
    from get_port_info_linux import GetPortInfoCommandLinux
    from get_port_info_windows import GetPortInfoCommandWindows
    # from fw_reset_commands import GetDeviceResetLevel, SetDeviceReset

except Exception as e:
    print("-E- could not import : %s" % str(e))
    sys.exit(1)


class MftCorePyPlugin(neohost_plugin_ifc.AbsNeoHostPluginIFC):
    def __init__(self):
        super(MftCorePyPlugin, self).__init__(
            MftCoreDefs.MFT_CORE_PLUGIN_NAME,
            MftCoreDefs.MFT_CORE_PLUGIN_DESC,
            MftCoreDefs.MFT_CORE_PLUGIN_VER)
        self.add_command(GetSystemServerInfoCommand())
        if not  NeoHostCommon.isFreebsdOs():
            self.add_command(GetInterfaceInfoCommand())
        # self.add_command(GetDeviceResetLevel())
        # self.add_command(SetDeviceReset())

        if NeoHostCommon.isWindowsOs():
            self.add_command(GetPortInfoCommandWindows())
        elif not NeoHostCommon.isFreebsdOs():
            self.add_command(GetPortInfoCommandLinux())
