# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) 2016-2017, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Samer Deeb
# @date: Dec 12, 2016


from datetime import datetime
import json
import os
import logging

from mft_debug_defs import MftDebugDefs
from mft_debug_exceptions import MftDebugException
import neohost_plugin_ifc as APIFC
import server_sysinfo

logger = logging.getLogger("neohost." + __name__)


class DebugGetSystemInfo(APIFC.AbsNeoHostCommandIFC):
    def __init__(self):
        super(DebugGetSystemInfo, self).__init__(
            cmd_name="DebugGetSystemInfo",
            cmd_desc="get dump of various system information",
            cmd_type=APIFC.EnumCmdType.Cmd_Type_Get,
            cmd_scope=APIFC.EnumCmdScope.Cmd_Scope_System,
            supp_exec_mask=APIFC.EnumCmdExecMode.Cmd_Exec_Mode_All,
            cmd_in_desc="dumpDir: Dump directory path",
            cmd_out_desc="dumpFilePath",
            extra_str="")

    def execute_command(self, json_request, exec_opt):
        logger.info("Executing DebugGetSystemInfo command..")
        req = json.loads(json_request)
        dumpDir = req["dumpDir"]
        createDir = req.get("createDir", False)
        if not os.path.isdir(dumpDir):
            if not createDir:
                self.printToLogAndRaiseMftDebugException(
                    "Failed to Open directory: %s, directory does not exist" % dumpDir)
            try:
                os.mkdir(dumpDir)
            except OSError:
                self.printToLogAndRaiseMftDebugException(
                    "Failed to create directory: %s" % dumpDir)

        dt_now = datetime.now().strftime('%Y%m%d-%H%M%S.%f')[:-3]
        file_name = "%s_%s.txt" % (self.get_command_name(), dt_now)
        dumpFilePath = os.path.join(dumpDir, file_name)
        try:
            server_sysinfo.get_server_info(out_file=dumpFilePath)
        except Exception as e:
            self.printToLogAndRaiseMftDebugException(str(e))
        result = {
            "dumpFilePath": dumpFilePath
        }
        logger.info("finished executing DebugGetSystemInfo command.")
        return MftDebugDefs.MFT_DEBUG_STATUS_SUCCESS, json.dumps(result)


    def printToLogAndRaiseMftDebugException(self, msg):
        logger.error(msg)
        raise MftDebugException(msg)