# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# @author: Samer Deeb
# @data: May 10, 2017


import json

import neohost_plugin_ifc as ACI
from mft_fw_defs import MftFwDefs


class GetDeviceThermalThresholds(ACI.AbsNeoHostCommandIFC):
    THRESHOLDS = [
        ("Normal", None, 100),
        ("Warning", 100, 105),
        ("Critical", 105, 115),
        ("Fatal", 115, 120),
        ("Shutdown", 120, None),
    ]

    def __init__(self):
        super(GetDeviceThermalThresholds, self).__init__(
            cmd_name="GetDeviceThermalThresholds",
            cmd_desc="Get thermal threshoulds of device",
            cmd_type=ACI.EnumCmdType.Cmd_Type_Get,
            cmd_scope=ACI.EnumCmdScope.Cmd_Scope_Device,
            supp_exec_mask=ACI.EnumCmdExecMode.Cmd_Exec_Mode_All,
            cmd_in_desc="devUid - device UID",
            cmd_out_desc="thermal thresholds",
            extra_str="")

    def execute_command(self, json_request, exec_opt):
        req = json.loads(json_request)
        _ = req["devUid"]
        thresholds = []
        for th in self.THRESHOLDS:
            threshold, lower, higher = th
            th_data = {
                "threshold": threshold
            }
            thresholds.append(th_data)
            if lower is not None:
                th_data["lower"] = lower
            if higher is not None:
                th_data["higher"] = higher
        return MftFwDefs.MFT_FW_STATUS_SUCCESS, json.dumps(thresholds)
