#!/usr/bin/python
# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

try:
    import sys
    import neohost_plugin_ifc
    from mft_fw_defs import MftFwDefs

    from fw_reset_commands import GetDeviceResetLevel, SetDeviceReset

except Exception as e:
    print("-E- could not import : %s" % str(e))
    sys.exit(1)


class MftFwPyPlugin(neohost_plugin_ifc.AbsNeoHostPluginIFC):
    def __init__(self):
        super(MftFwPyPlugin, self).__init__(
            MftFwDefs.MFT_FW_PLUGIN_NAME,
            MftFwDefs.MFT_FW_PLUGIN_DESC,
            MftFwDefs.MFT_FW_PLUGIN_VER)
        self.add_command(GetDeviceResetLevel())
        self.add_command(SetDeviceReset())
