# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Simon Raviv
# @date: December 18, 2017

from schema_keys import SchemaKeys as Keys
from api_object import APIObject


class AnalysisAttribute(APIObject):
    """ Describes performance analysis attribute API object.
    """

    def __init__(self, analysis_attribute=None):
        super(AnalysisAttribute, self).__init__(Keys.ANALYSIS_ATTRIBUTE)

        self.api_objects.update({
            Keys.NAME: analysis_attribute.name,
            Keys.DESCRIPTION: analysis_attribute.description,
            Keys.UNITS: analysis_attribute.units_measure,
            Keys.TIMESTAMP: analysis_attribute.timestamp,
            Keys.VALUE: analysis_attribute.value,
            Keys.VALUE_TYPE: analysis_attribute.value_type,
            Keys.GUI_CMPONENT: analysis_attribute.gui_component})
