# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Simon Raviv
# @date: April 02, 2017


class APIObject(object):
    """ Defines a class which can be provided as an item
        for API functions.
    """
    def __init__(self, key, keep_list=False):
        self.key = key
        self.keep_list = keep_list
        self.api_objects = {}

    def to_dictionary(self):
        """ Transform an APIObject to a dictionary.
        """
        api_dict = {self.key: {}}
        for obj_key, obj_value in self.api_objects.iteritems():
            if isinstance(obj_value, APIObject):
                api_dict[self.key][obj_key] = obj_value.to_dictionary()
            elif isinstance(obj_value, list):
                obj_list = []
                for internal_obj in obj_value:
                    if isinstance(internal_obj, basestring):
                        obj_list.append(internal_obj)
                    else:
                        obj_list.append(internal_obj.to_dictionary())
                api_dict[self.key][obj_key] = {}
                if self.keep_list:
                    api_dict[self.key][obj_key] = obj_list
                else:
                    for obj_dict in obj_list:
                        api_dict[self.key][obj_key].update(obj_dict)
            else:
                api_dict[self.key][obj_key] = obj_value

        return api_dict
