# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Tal Gilboa
# @date: April 02, 2017

from performance.performance_exceptions import PerformanceException
from api_object import APIObject
from performance.common.severity import Severity


class InfoEntry(APIObject):
    """ Defines a class representing InfoEntry API class
    """
    def __init__(self, name, is_leaf, in_val="", desc="",
                 severity=Severity.UNDEFINED, comment=""):
        super(InfoEntry, self).__init__(name)

        self.is_leaf = is_leaf
        if in_val:
            self.verify_value(in_val)
            val = in_val
        else:
            if self.is_leaf:
                val = ""
            else:
                val = []

        self.api_objects.update({"displayName": name, "val": val})
        self.update_description(desc)
        self.update_severity(severity)
        self.update_comment(comment)

    def update_value(self, val):
        """ Sets the entry's value field.
            If the field already set, add the new value to the value list.
            Val field can be a string or a list of entries.
        """
        self.verify_value(val)
        if self.is_leaf:
            self.api_objects["val"] = val
        else:
            self.api_objects["val"] += [val]

    def update_description(self, desc):
        """ Sets the entry's description field.
        """
        self.api_objects["desc"] = desc

    def update_severity(self, severity):
        """ Sets the entry's severity field.
        """
        self.api_objects["severity"] = severity

    def update_comment(self, comment):
        """ Sets the entry's comment field.
        """
        self.api_objects["comment"] = comment

    def verify_value(self, val):
        """ Verify a value is valid for the entry's value field.
            valid values are string for leaf objects.
            and APiObjects for non leaf objects.
        """
        if self.is_leaf and isinstance(val, str) or\
                not self.is_leaf and isinstance(val, APIObject) or\
                isinstance(val, dict):
            return
        raise PerformanceException(
            "Invalid value provided to InfoEntry object")
