# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Simon Raviv
# @date: April 02, 2017

from schema_keys import SchemaKeys as Keys
from api_object import APIObject


class PerformanceCounters(APIObject):
    """ Describes a top level performance counters API object.
    """

    def __init__(self, counters=None, metadata=None, analysis=None,
                 analysis_metadata=None):
        super(PerformanceCounters, self).__init__(
            Keys.PERFORMANCE_COUNTERS, True)
        self.api_objects.update({Keys.COUNTERS: counters})
        self.api_objects.update(metadata.to_dictionary())
        if analysis and analysis_metadata:
            self.api_objects.update({Keys.ANALYSIS: analysis})
            self.api_objects.update(analysis_metadata.to_dictionary())
