# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Simon Raviv
# @date: April 02, 2017

class SchemaKeys(object):
    """ Describes a key in the API schema.
        Used for creating output from API object.
    """

    SYSTEM_INFO = "sysInfo"
    INFO_ITEM = "infoItem"
    INFO_ENTRY = "infoEntry"
    CPU = "CPU"
    OS = "OS"
    COUNTER = "counter"
    COUNTERS = "counters"
    PERFORMANCE_COUNTERS = "performanceCounters"
    METADATA = "metadata"
    METADATAGROUP = "metadataGroup"
    SYS_STAT = "GetSystemStaticPerformanceConfig"
    DEVICE_COUNTERS = "GetDevicePerformanceCounters"
    GROUPS = "groups"
    GROUP = "group"
    ANALYSIS = "analysis"
    ANALYSIS_ATTRIBUTE = "analysisAttribute"
    ANALYSIS_ATTRIBUTES = "analysisAttributes"
    ANALYSIS_METADATAGROUP = "analysisMetadataGroup"
    ANALYSIS_METADATA = "analysisMetadata"
    NAME = "name"
    DESCRIPTION = "description"
    UNITS = "units"
    TIMESTAMP = "timestamp"
    VALUE = "value"
    VALUE_TYPE = "valueType"
    UTILIZATION_PERCENT = "utilizationPercentage"
    UTILIZATION_REF = "utilizationReference"
    GOOD_THRESHOLD = "thresholdGood"
    BAD_THRESHOLD = "thresholdBad"
    GUI_CMPONENT = "GUIComponent"

    def __init__(self):
        self.schema_dict = {}
        self.schema_dict[SchemaKeys.SYS_STAT] = [
            SchemaKeys.SYSTEM_INFO,
            SchemaKeys.INFO_ITEM,
            SchemaKeys.INFO_ENTRY]
        self.schema_dict[SchemaKeys.DEVICE_COUNTERS] = [
            SchemaKeys.PERFORMANCE_COUNTERS,
            SchemaKeys.COUNTER,
            SchemaKeys.METADATA,
            SchemaKeys.ANALYSIS_ATTRIBUTE,
            SchemaKeys.ANALYSIS_METADATAGROUP,
            SchemaKeys.ANALYSIS_METADATAGROUP]

    def get_key(self, key, level):
        """ Gets the appropriate key to the provided API level
        """
        return self.schema_dict[key][level]
