# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Simon Raviv
# @date: December 21, 2017

class AnalyzersNames(object):
    """ Represents analyzers names ENUM.
    """
    RX_PACKET_RATE = "RX Packet Rate"
    TX_PACKET_RATE = "TX Packet Rate"
    PCI_AVG_LATENCY = "PCIe Avg Latency"
    PCI_MIN_LATENCY = "PCIe Min Latency"
    PCI_MAX_LATENCY = "PCIe Max Latency"
    PCI_PXT_TO_PXDP_LATENCY_AVG = \
        "PCIe Internal Avg Latency"
    PCI_PXT_TO_PXDP_LATENCY_MIN = \
        "PCIe Internal Min Latency"
    PCI_PXT_TO_PXDP_LATENCY_MAX = \
        "PCIe Internal Max Latency"
    PCI_PXT_TO_ARM_LATENCY_AVG = \
        "PCIe to ARM Avg Latency"
    PCI_PXT_TO_ARM_LATENCY_MIN = \
        "PCIe to ARM Min Latency"
    PCI_PXT_TO_ARM_LATENCY_MAX = \
        "PCIe to ARM Max Latency"
    TX_BW = "TX BandWidth"
    RX_BW = "RX BandWidth"
    PCI_INBOUND_USED_BW = "PCIe Inbound Used BW"
    PCI_OUTBOUND_USED_BW = "PCIe Outbound Used BW"
    PCI_INBOUND_AVAILABLE_BW = "PCIe Inbound Available BW"
    PCI_OUTBOUND_AVAILABLE_BW = "PCIe Outbound Available BW"
    PCI_INBOUND_BW = "PCIe Inbound BW Utilization"
    PCI_OUTBOUND_BW = "PCIe Outbound BW Utilization"
    RX_OPTIMAL_HOPS = "RX Optimal Hops Per Packet Per Pipe"
    RX_OPTIMAL_PACKET_RATE_BOTTLENECK = \
        "RX Optimal Packet Rate Bottleneck"
    RX_HOPS = "RX Hops Per Packet"
    RX_PACKET_RATE_BOTTLENECK = "RX Packet Rate Bottleneck"
    TX_OPTIMAL_HOPS = "TX Optimal Hops Per Packet Per Pipe"
    TX_OPTIMAL_PACKET_RATE_BOTTLENECK = \
        "TX Optimal Packet Rate Bottleneck"
    TX_HOPS = "TX Hops Per Packet"
    TX_PACKET_RATE_BOTTLENECK = "TX Packet Rate Bottleneck"
    RX_INDIRECT_MEM_KEY_RATE = "RX Indirect Memory Keys Rate"
