# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Simon Raviv
# @date: June 22, 2017

class CountersNames(object):
    """ Represents counters names ENUM.
    """
    DEVICE_CLOCKS = "Chip Frequency"
    DEVICE_CLOCKS_WRAPAROUND = "Chip Frequency Wraparound"
    # TPT:
    TPT_L0_MTT_HIT = "Level 0 MTT Cache Hit"
    TPT_L0_MTT_MISS = "Level 0 MTT Cache Miss"
    TPT_L1_MTT_HIT = "Level 1 MTT Cache Hit"
    TPT_L1_MTT_MISS = "Level 1 MTT Cache Miss"
    TPT_L0_MPT_HIT = "Level 0 MPT Cache Hit"
    TPT_L0_MPT_MISS = "Level 0 MPT Cache Miss"
    TPT_L1_MPT_HIT = "Level 1 MPT Cache Hit"
    TPT_L1_MPT_MISS = "Level 1 MPT Cache Miss"
    TPT_INDIRECT_MEM_KEY = "Indirect Memory Key Access"
    # PXTH:
    PXT_PERF_RD_ICMC_PUSH_LINK0 = "ICM Cache Miss"
    # PXTL:
    PXT_PXD_READY_BP = "PCIe Internal Back Pressure"
    PXT_PCI_READ_BP = "Outbound Stalled Reads"
    PXT_PCI_WRITE_BP = "Outbound Stalled Writes"
    PXT_LACK_IN_CMP_ENG_BP = "PCIe Read Stalled due to No Read Engines"
    PXT_PCI_READ_STUCK_DUE_TO_NO_COMPLETION_BUFFER = \
        "PCIe Read Stalled due to No Completion Buffer"
    PXT_PCI_READ_STUCK_DUE_TO_NO_READ_ENGINES = \
        "PCIe Read Stalled due to No Read Engines"
    PXT_PCI_READ_STUCK_DUE_TO_BYTE_LIMIT = \
        "PCIe Read Stalled due to No Completion Buffer"
    PXT_PCI_READ_STUCK_DUE_TO_ORDERING = "PCIe Read Stalled due to Ordering"
    RXS_NO_PXT_CREDITS = "Back Pressure from PCIe to Packet Scatter"
    # RXT:
    RXT_CTRL_PERF_SLICE_LOAD_SLOW = "RX Steering Packets"
    RXT_CTRL_PERF_SLICE_LOAD_FAST = "RX Steering Packets Fast Path"
    RXT_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE = "RX Steering Pipe 0"
    RXT_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE = "RX Steering Pipe 1"
    RXT_STEERING_PERF_COUNT_STEERING0_CACHE_MISS = \
        "RX Steering Cache Miss Pipe 0"
    RXT_STEERING_PERF_COUNT_STEERING1_CACHE_MISS = \
        "RX Steering Cache Miss Pipe 1"
    RXT_STEERING_PERF_COUNT_STEERING0_CACHE_HIT = \
        "RX Steering Cache Hit Pipe 0"
    RXT_STEERING_PERF_COUNT_STEERING1_CACHE_HIT = \
        "RX Steering Cache Hit Pipe 1"
    RXT_STEERING_PERF_COUNT_STEERING0_CACHE_TOT = \
        "RX Steering Cache Access Pipe 0"
    RXT_STEERING_PERF_COUNT_STEERING1_CACHE_TOT = \
        "RX Steering Cache Access Pipe 1"
    # RXD
    RXD_CTRL_IPSEC_PACKET = "RX IPsec Packets"
    RXD_CTRL_G_CREDIT_PSA1_SLICE_HOST_0 = \
        "Back Pressure from RXD to PSA"
    # RXB:
    RXB_S1HOST_ARBITER_PERF_DESC_BUFFER_CREDIT_HOST0 = \
        "Back Pressure from RXB Buffer to RXB FIFO"
    RXB_RXT_S1PSA_SWITCH_PERF_COUNT = \
         "Back Pressure from PSA switch to RXT"
    RXB_S1PSA_SWITCH_PERF_COUNT = \
        "Back Pressure from PSA switch to RXB"
    RXB_RXD_S1PSA_SWITCH_PERF_COUNT = \
        "Back Pressure from PSA switch to RXD"
    RXB_RXT_NO_SLOW_PATH_CRED_PERF_COUNT = \
        "Back Pressure from Packet Processing to RX Packet Buffer"
    RXB_RXS_NO_SLOW_PATH_CREDITS = \
        "Back Pressure from Packet Scatter to RX Packet Buffer"
    RXB_LRO_FIFO_PERF_COUNT2 = "LRO Session Timeout"
    RXB_PORT0_BUFFER_FULL_PERF_COUNT_PORT0 = "RX Packet Buffer Full Port 1"
    RXB_PORT1_BUFFER_FULL_PERF_COUNT_PORT1 = "RX Packet Buffer Full Port 2"
    RXB_BW_COUNT_PERF_COUNT_0_1 = "RX Packet Buffer 64[B] #0"
    RXB_BW_COUNT_PERF_COUNT_0_2 = "RX Packet Buffer Packets #0"
    RXB_BW_COUNT_PERF_COUNT_1_1 = "RX Packet Buffer 64[B] #1"
    RXB_BW_COUNT_PERF_COUNT_1_2 = "RX Packet Buffer Packets #1"
    # PTB:
    PTB_PORT_IF_48B_PORT_0 = "RX Packet Buffer 48[B] #0"
    PTB_PORT_IF_48B_PORT_1 = "RX Packet Buffer 48[B] #1"
    PTB_PORT_IF_PACKETS_ALL_PORTS = "RX Packet Buffer Packets [#0 #1]"
    # RXW:
    RXW_PERF_COUNT_TPT_CREDIT = \
        "Back Pressure from Internal MMU to RX Descriptor Handling"
    RXW_PERF_WB_HIT = "Receive WQE Cache Hit"
    RXW_PERF_WB_MISS = "Receive WQE Cache Miss"
    RXW_PERF_RX_L1_SLOW_MISS_REQSL = "TBD"
    RXW_PERF_RX_L1_SLOW_HIT_REQSL = "TBD"
    RXW_PERF_RX_L1_FAST_MISS_REQSL = "TBD"
    RXW_PERF_RX_L1_FAST_HIT_REQSL = "TBD"
    # RXC:
    RXC_EQ_ALL_SLICES_BUSY = "EQ All State Machines Busy"
    RXC_CQ_ALL_SLICES_BUSY = "CQ All State Machines Busy"
    RXC_MSIX_ALL_SLICES_BUSY = "MSI-X All State Machines Busy"
    RXC_CQE_ZIP_OPEN_SESSION = "CQE Compression Sessions"
    RXC_CQE_ZIP_MERGING_CQE = "Compressed CQEs"
    RXC_CQE_ZIP_WRITING_8_CQES = "Compressed CQE Strides"
    RXC_CLOSING_ZIP_SESSION_LRO = "Compression Session Closed due to LRO"
    RXC_CLOSING_ZIP_SESSION_EQE = "Compression Session Closed due to EQE"
    RXC_CLOSING_ZIP_SESSION_TIMEOUT = \
        "Compression Session Closed due to Timeout"
    RXC_CLOSING_ZIP_SESSION_NOT_MATCH = \
        "Compression Session Closed due to Mismatch"
    RXC_CLOSING_ZIP_SESSION_PX_IDLE = \
        "Compression Session Closed due to PCIe Idle"
    RXC_CLOSING_ZIP_SESSION_S2CQE = "Compression Session Closed due to S2CQE"
    # SXW:
    SXW_QP_DONE_DUE_TO_LIMITED = \
        "TX Descriptor Handling Stopped due to Limited State"
    SXW_QP_DONE_DUE_TO_VL_LIMITED = \
        "TX Descriptor Handling Stopped due to Limited VL"
    SXW_QP_DONE_DUE_TO_DESCHED = \
        "TX Descriptor Handling Stopped due to De-schedule"
    SXW_QP_DONE_DUE_TO_WORK_DONE = \
        "TX Descriptor Handling Stopped due to Work Done"
    SXW_QP_DONE_DUE_TO_E2E_CREDITS = \
        "TX Descriptor Handling Stopped due to E2E Credits"
    SXW_PACKET_SEND_SXW2SXP_GO_VID = "TX Packets"
    SXW_PERF_COUNT_STEERING_HIT = "TX Steering Hit"
    SXW_PERF_COUNT_STEERING_MISS = "TX Steering Miss"
    SXW_STEERING_PERF_COUNT_CACHE_HIT = "TX Steering Cache Hit"
    SXW_STEERING_PERF_COUNT_CACHE_MISS = "TX Steering Cache Miss"
    SXW_STEERING_PERF_COUNT_CACHE_TOT = "TX Steering Cache Total Access"
    SXW_PERF_COUNT_STEERING_RSE0 = "TX Steering"
    # SXD:
    SXD_NO_SLOW_PATH_CREDITS = \
        "Back Pressure from TX Descriptor Handling to Scheduling"
    # SXP:
    SXP_SXP_LINE_TRANSMITTED_PERF_COUNT0 = "Port Line Transmitted"
    SXP_LINE_TRANSMITTED_PORT0 = "Line Transmitted Port 1"
    SXP_LINE_TRANSMITTED_PORT1 = "Line Transmitted Port 2"
    SXP_LINE_TRANSMITTED_LOOPBACK = "Line Transmitted Loop Back"
    SXP_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE = "TX Steering Pipe 0"
    SXP_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE = "TX Steering Pipe 1"
    SXP_PERF_COUNT_STEERING0_HIT = "TX Steering Hit Pipe 0"
    SXP_PERF_COUNT_STEERING0_MISS = "TX Steering Miss Pipe 0"
    SXP_PERF_COUNT_STEERING1_HIT = "TX Steering Hit Pipe 1"
    SXP_PERF_COUNT_STEERING1_MISS = "TX Steering Miss Pipe 1"
    SXP_PERF_COUNT_STEERING0_CACHE_1_MISS = "TX Steering Cache Miss Pipe 0"
    SXP_PERF_COUNT_STEERING1_CACHE_1_MISS = "TX Steering Cache Miss Pipe 1"
    SXP_PERF_COUNT_STEERING0_CACHE_1_HIT = "TX Steering Cache Hit Pipe 0"
    SXP_PERF_COUNT_STEERING1_CACHE_1_HIT = "TX Steering Cache Hit Pipe 1"
    SXP_BW_COUNT_PERF_COUNT_0_2 = "TX Packets"
    SXP_STEERING_0_TOTAL_CACHE_ACCESS = "TX Steering Cache Access Pipe 0"
    SXP_STEERING_1_TOTAL_CACHE_ACCESS = "TX Steering Cache Access Pipe 1"
    SXP_E2E_CACHE_TOTAL_LOOKUPS = "TX Steering Learning Cache Lookups"
    SXP_E2E_CACHE_HIT = "TX Steering Learning Cache Hit"
    SXP_E2E_CACHE_MISS = "TX Steering Learning Cache Miss"
    SXP_E2E_CACHE_LEARN = "TX Steering Learning Cache Learn"
    SXP_BW_COUNT_PERF_COUNT_0_1 = "TX Packet Buffer 64[B] #0"
    SXP_BW_COUNT_PERF_COUNT_0_2 = "TX Packet Buffer Packets #0"
    SXP_BW_COUNT_PERF_COUNT_1_1 = "TX Packet Buffer 64[B] #1"
    SXP_BW_COUNT_PERF_COUNT_1_2 = "TX Packet Buffer Packets #1"
    # RXPS:
    RXPS_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE = \
        "RX Steering Pipe 0"
    RXPS_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE = \
        "RX Steering Pipe 1"
    RXPS_STEERING_PERF_COUNT_STEERING0_CACHE_HIT = \
        "RX Steering Cache Hit Pipe 0"
    RXPS_STEERING_PERF_COUNT_STEERING1_CACHE_HIT = \
        "RX Steering Cache Hit Pipe 1"
    RXPS_STEERING_PERF_COUNT_STEERING0_CACHE_MISS = \
        "RX Steering Cache Miss Pipe 0"
    RXPS_STEERING_PERF_COUNT_STEERING1_CACHE_MISS = \
        "RX Steering Cache Miss Pipe 1"
    RXPS_STEERING_PERF_COUNT_STEERING0_CACHE_TOT = \
        "RX Steering Cache Access Pipe 0"
    RXPS_STEERING_PERF_COUNT_STEERING1_CACHE_TOT = \
        "RX Steering Cache Access Pipe 1"
    RXPS_E2E_CACHE_TOTAL_LOOKUPS = "RX Steering Learning Cache Lookups"
    RXPS_E2E_CACHE_HIT = "RX Steering Learning Cache Hit"
    RXPS_E2E_CACHE_MISS = "RX Steering Learning Cache Miss"
    RXPS_E2E_CACHE_LEARN = "RX Steering Learning Cache Learn"
    # PSA:
    PSA_TX0_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE = "TX_PSA0 Steering Pipe 0"
    PSA_TX0_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE = "TX_PSA0 Steering Pipe 1"
    PSA_TX1_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE = "TX_PSA1 Steering Pipe 0"
    PSA_TX1_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE = "TX_PSA1 Steering Pipe 1"
    PSA_TX0_PERF_COUNT_STEERING0_HIT = "TX Steering Hit Pipe 0"
    PSA_TX0_PERF_COUNT_STEERING1_HIT = "TX Steering Hit Pipe 1"
    PSA_TX1_PERF_COUNT_STEERING0_MISS = "TX Steering Miss Pipe 0"
    PSA_TX1_PERF_COUNT_STEERING1_MISS = "TX Steering Miss Pipe 1"
    PSA_TX0_PERF_COUNT_STEERING0_CACHE_1_MISS = "TX_PSA0 Steering Cache Miss Pipe 0"
    PSA_TX0_PERF_COUNT_STEERING1_CACHE_1_MISS = "TX_PSA0 Steering Cache Miss Pipe 1"
    PSA_TX1_PERF_COUNT_STEERING0_CACHE_1_MISS = "TX_PSA1 Steering Cache Miss Pipe 0"
    PSA_TX1_PERF_COUNT_STEERING1_CACHE_1_MISS = "TX_PSA1 Steering Cache Miss Pipe 1"
    PSA_TX0_PERF_COUNT_STEERING0_CACHE_1_HIT = "TX_PSA0 Steering Cache Hit Pipe 0"
    PSA_TX0_PERF_COUNT_STEERING1_CACHE_1_HIT = "TX_PSA0 Steering Cache Hit Pipe 1"
    PSA_TX1_PERF_COUNT_STEERING0_CACHE_1_HIT = "TX_PSA1 Steering Cache Hit Pipe 0"
    PSA_TX1_PERF_COUNT_STEERING1_CACHE_1_HIT = "TX_PSA1 Steering Cache Hit Pipe 1"
    PSA_TX0_STEERING_0_TOTAL_CACHE_ACCESS = "TX_PSA0 Steering Cache Access Pipe 0"
    PSA_TX0_STEERING_1_TOTAL_CACHE_ACCESS = "TX_PSA0 Steering Cache Access Pipe 1"
    PSA_TX1_STEERING_0_TOTAL_CACHE_ACCESS = "TX_PSA1 Steering Cache Access Pipe 0"
    PSA_TX1_STEERING_1_TOTAL_CACHE_ACCESS = "TX_PSA1 Steering Cache Access Pipe 1"
    PSA_RX0_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE = \
        "RX_PSA0 Steering Pipe 0"
    PSA_RX0_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE = \
        "RX_PSA0 Steering Pipe 1"
    PSA_RX1_STEERING_PERF_COUNT_STEERING0_RSE_WORK_RATE = \
        "RX_PSA1 Steering Pipe 0"
    PSA_RX1_STEERING_PERF_COUNT_STEERING1_RSE_WORK_RATE = \
        "RX_PSA1 Steering Pipe 1"
    PSA_RX0_STEERING_PERF_COUNT_STEERING0_CACHE_HIT = \
        "RX_PSA0 Steering Cache Hit Pipe 0"
    PSA_RX0_STEERING_PERF_COUNT_STEERING1_CACHE_HIT = \
        "RX_PSA0 Steering Cache Hit Pipe 1"
    PSA_RX1_STEERING_PERF_COUNT_STEERING0_CACHE_HIT = \
        "RX_PSA1 Steering Cache Hit Pipe 0"
    PSA_RX1_STEERING_PERF_COUNT_STEERING1_CACHE_HIT = \
        "RX_PSA1 Steering Cache Hit Pipe 1"
    PSA_RX0_STEERING_PERF_COUNT_STEERING0_CACHE_MISS = \
        "RX_PSA0 Steering Cache Miss Pipe 0"
    PSA_RX0_STEERING_PERF_COUNT_STEERING1_CACHE_MISS = \
        "RX_PSA0 Steering Cache Miss Pipe 1"
    PSA_RX1_STEERING_PERF_COUNT_STEERING0_CACHE_MISS = \
        "RX_PSA1 Steering Cache Miss Pipe 0"
    PSA_RX1_STEERING_PERF_COUNT_STEERING1_CACHE_MISS = \
        "RX_PSA1 Steering Cache Miss Pipe 1"
    PSA_RX0_STEERING_PERF_COUNT_STEERING0_CACHE_TOT = \
        "RX_PSA0 Steering Cache Access Pipe 0"
    PSA_RX0_STEERING_PERF_COUNT_STEERING1_CACHE_TOT = \
        "RX_PSA0 Steering Cache Access Pipe 1"
    PSA_RX1_STEERING_PERF_COUNT_STEERING0_CACHE_TOT = \
        "RX_PSA1 Steering Cache Access Pipe 0"
    PSA_RX1_STEERING_PERF_COUNT_STEERING1_CACHE_TOT = \
        "RX_PSA1 Steering Cache Access Pipe 1"
    # PXDP:
    PXDP_RX_128B_DATA = "PCIe Inbound 128[B]"
    PXDP_RX_128B_TOTAL = "PCIe Inbound 128[B] Limit"
    PXDP_TX_128B_DATA = "PCIe Outbound 128[B]"
    # Regular Counters:
    PXT_TO_PXDP_LATENCY_LINK0_AVG = "PCIe Internal Avg Latency"
    PXT_TO_PXDP_LATENCY_LINK0_MIN = "PCIe Internal Min Latency"
    PXT_TO_PXDP_LATENCY_LINK0_MAX = "PCIe Internal Max Latency"
    PCI_LATENCY_LINK0_AVG = "PCIe Avg Latency"
    PCI_LATENCY_LINK0_MIN = "PCIe Min Latency"
    PCI_LATENCY_LINK0_MAX = "PCIe Max Latency"
    PXT_TO_ARM_LATENCY_AVG = "PCIe to ARM Avg Latency"
    PXT_TO_ARM_LATENCY_MIN = "PCIe to ARM Min Latency"
    PXT_TO_ARM_LATENCY_MAX = "PCIe to ARM Max Latency"
