# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Simon Raviv
# @date: April 02, 2017


from performance.common.device_ids import DeviceIDs


class DeviceFamily(object):
    """ Describes a Mellanox device family.
    """
    CONNECTX4 = "ConnectX-4"
    CONNECTX5 = "ConnectX-5"
    BLUEFIELD = "BlueField"
    CONNECTX6 = "ConnectX-6"
    CONNECTX6DX = "ConnectX-6Dx"
    BLUEFIELD2 = "BlueField2"
    UNKNOWN = "N/A"

    @classmethod
    def get_family(cls, device_id):
        """ Returns device family by device IDs.
        """
        if device_id in DeviceIDs.ALL_CONNECTX4:
            return cls.CONNECTX4
        if device_id in DeviceIDs.ALL_CONNECTX5:
            return cls.CONNECTX5
        if device_id in DeviceIDs.ALL_BLUEFIELD:
            return cls.BLUEFIELD
        if device_id in DeviceIDs.ALL_CONNECTX6:
            return cls.CONNECTX6
        if device_id in DeviceIDs.ALL_CONNECTX6DX:
            return cls.CONNECTX6DX
        if device_id in DeviceIDs.ALL_BLUEFIELD2:
            return cls.BLUEFIELD2
        return cls.UNKNOWN
