# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Simon Raviv
# @date: May 24, 2017


class DeviceIDs(object):
    """ Describes device IDs.
    """
    CONNECTX4 = [4115, 4116]
    CONNECTX4LX = [4117, 4118]
    CONNECTX5 = [4119, 4120]
    CONNECTX5EX = [4121, 4122]
    BLUEFIELD = [41682, 41683]
    BLUEFIELD2 = [41685, 41686]
    CONNECTX6 = [4123, 4124]
    CONNECTX6DX = [4125, 4126]
    ALL_CONNECTX4 = (CONNECTX4 + CONNECTX4LX)
    ALL_CONNECTX5 = (CONNECTX5 + CONNECTX5EX)
    ALL_BLUEFIELD = (BLUEFIELD + BLUEFIELD2)
    ALL_CONNECTX6 = (CONNECTX6)
    ALL_CONNECTX6DX = (CONNECTX6DX)
    ALL = (ALL_CONNECTX4 + ALL_CONNECTX5 + ALL_BLUEFIELD + ALL_CONNECTX6 + ALL_CONNECTX6DX)
