# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Simon Raviv
# @date: May 05, 2017

class Units(object):
    """ Describes units in the chip.
    """
    # Note that unit name should be in the following convention,
    # due to backward compatibility issues between BE and UI:
    # Convention: Unit string = "X(Y)"
    # Where X is the Architecture name and Y is the name will
    # be visible in the GUI/CLI.
    TPT = "TPT(Internal MMU)"
    PXDP = "PXDP(PCIe)"
    PXT = "PXT(PCIe)"
    PXTL = "PXTL(PCIe)"
    PXTH = "PXTH(PCIe)"
    RXD = "RXD(IPsec Decryption)"
    RXB = "RXB(RX Packet Buffer)"
    PTB = "PTB(RX Packet Buffer)"
    RXT = "RXT(RX Packet Processing)"
    RXW = "RXW(RX Descriptor Handling)"
    RXS = "RXS(Packet Scatter)"
    RXC = "RXC(Completion Engine)"
    SXD = "SXD(Scheduling & QoS)"
    SXP = "SXP(TX Packet Processing & Transmission)"
    SXP_E2E_CACHE = "SXP_E2E_cache(TX Packet Processing & Transmission)"
    SXS_E2E_CACHE = "SXS_E2E_cache(TX Packet Processing & Transmission)"
    SXW = "SXW(TX Descriptor Handling)"
    RXPS = "RXPS(RX Packet Processing)"
    RXPS_E2E_CACHE = "RXPS_E2E_cache(RX Packet Processing)"
    SXS = "SXS(TX Packet Processing & Transmission)"
    PSA_RX0 = "PSA(RX Packet Processing)"
    PSA_RX1 = "PSA(RX Packet Processing)"
    PSA_TX0 = "PSA(TX Packet Processing)"
    PSA_TX1 = "PSA(TX Packet Processing)"
    ICMC = "ICMC(ICMC Cache)"
    NONE = "N/A"
