# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Simon Raviv
# @date: January 03, 2018


from performance.common.analyzers_names import AnalyzersNames as Analyzers


class AnalyzersNamesDescriptionMap(object):
    """ Describes names mapping between analyzer's name to it's description.
    """

    def __init__(self):
        self.__analyzers_map = dict()
        self.__initialize_map()

    def __initialize_map(self):
        """ Initialization of analyzers name map.
        """
        self.__analyzers_map[Analyzers.RX_PACKET_RATE] = \
            ("Received packet rate")
        self.__analyzers_map[Analyzers.TX_PACKET_RATE] = \
            ("Transmitted packet rate")
        self.__analyzers_map[Analyzers.PCI_AVG_LATENCY] = \
            ("PCIe average latency")
        self.__analyzers_map[Analyzers.PCI_MIN_LATENCY] = \
            ("PCIe minimum latency")
        self.__analyzers_map[Analyzers.PCI_MAX_LATENCY] = \
            ("PCIe maximum latency")
        self.__analyzers_map[Analyzers.PCI_PXT_TO_PXDP_LATENCY_AVG] = \
            ("PCIe unit internal average latency")
        self.__analyzers_map[Analyzers.PCI_PXT_TO_PXDP_LATENCY_MIN] = \
            ("PCIe unit internal minimum latency")
        self.__analyzers_map[Analyzers.PCI_PXT_TO_PXDP_LATENCY_MAX] = \
            ("PCIe unit internal maximum latency")
        self.__analyzers_map[Analyzers.TX_BW] = \
            ("Transmitted bandwidth")
        self.__analyzers_map[Analyzers.RX_BW] = \
            ("Received bandwidth")
        self.__analyzers_map[Analyzers.PCI_INBOUND_USED_BW] = \
            ("PCIe inbound bandwidth used")
        self.__analyzers_map[Analyzers.PCI_OUTBOUND_USED_BW] = \
            ("PCIe outbound bandwidth used")
        self.__analyzers_map[Analyzers.PCI_INBOUND_AVAILABLE_BW] = \
            ("PCIe inbound bandwidth available")
        self.__analyzers_map[Analyzers.PCI_OUTBOUND_AVAILABLE_BW] = \
            ("PCIe outbound bandwidth available")
        self.__analyzers_map[Analyzers.PCI_INBOUND_BW] = \
            ("PCIe inbound bandwidth utilization")
        self.__analyzers_map[Analyzers.PCI_OUTBOUND_BW] = \
            ("PCIe outbound bandwidth utilization")
        self.__analyzers_map[Analyzers.RX_OPTIMAL_HOPS] = \
            ("RX theoretical optimal hops per packet per pipe")
        self.__analyzers_map[Analyzers.RX_OPTIMAL_PACKET_RATE_BOTTLENECK] = \
            ("RX hops bottleneck - theoretical optimal packet rate")
        self.__analyzers_map[Analyzers.RX_HOPS] = \
            ("RX hops per packet")
        self.__analyzers_map[Analyzers.RX_PACKET_RATE_BOTTLENECK] = \
            ("RX hops bottleneck - packet rate")
        self.__analyzers_map[Analyzers.TX_OPTIMAL_HOPS] = \
            ("TX theoretical optimal hops per packet per pipe")
        self.__analyzers_map[Analyzers.TX_OPTIMAL_PACKET_RATE_BOTTLENECK] = \
            ("TX hops bottleneck - theoretical optimal packet rate")
        self.__analyzers_map[Analyzers.TX_HOPS] = \
            ("TX hops per packet")
        self.__analyzers_map[Analyzers.TX_PACKET_RATE_BOTTLENECK] = \
            ("TX hops bottleneck - packet rate")
        self.__analyzers_map[Analyzers.RX_INDIRECT_MEM_KEY_RATE] = \
            ("RX indirect memory key access")

    def get_description(self, analyzer_name):
        """ Returns analyzer's description from its name.
        """
        return self.__analyzers_map.get(analyzer_name, '')
