# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Simon Raviv
# @date: April 02, 2017


class ConnectXDevice(object):
    """ Describe an abstract NIC device.
    """
    def __init__(self, mstdev, family):
        self.family = family
        self.dev_clock = 0
        self.device_id = 0
        self.mstdev = mstdev
        self.error_str = None
        self.sample_index = -1
        self._analyzers = list()

    def get_error(self):
        """ Gets the device's error if exists.
        """
        return self.error_str

    def set_error(self, err):
        """ Sets an error for the device.
        """
        if self.error_str:
            self.error_str += '\n' + err
        else:
            self.error_str = err

    def get_next_data(self):
        """ Get next performance data from the NIC.
        """
        return None

    @property
    def analyzers(self):
        """ Return the chip analyzers.
        """
        return self._analyzers

    @analyzers.setter
    def analyzers(self, analyzers):
        """ Set analyzers objects.
        """
        self._analyzers = analyzers
