# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Tal Gilboa
# @date: Mar 16, 2017

from performance.api.info_entry import InfoEntry
from performance.api.schema_keys import SchemaKeys
from performance.services.access_provider import AccessProvider


class CPU(InfoEntry):
    """ Describes the system's CPU
    """
    def __init__(self):
        super(CPU, self).__init__(SchemaKeys.CPU, False)
        self.access = AccessProvider.get_cpu_access()

    def query(self):
        """ Queries the system for the CPU information.
        """
        self.access.collect_info()
        entry = InfoEntry("Total CPU Cores", True,
                          in_val=str(self.access.total_cores),
                          desc="Number of total CPU cores")
        self.update_value(entry)
        entry = InfoEntry("CPU Cores Per NUMA Node", True,
                          in_val=str(self.access.physical_cores),
                          desc="Number of cores per NUMA node")
        sockets_entry = list()
        for socket, cores in self.access.sockets_cores.items():
            item = InfoEntry("NUMA " + str(socket), True,
                             in_val=str(cores).strip('[]'),
                             desc="NUMA {numa} cores".
                             format(numa=str(socket)))
            sockets_entry.append(item)
        entry.api_objects['val'] = sockets_entry
        self.update_value(entry)
        entry = InfoEntry("Sockets", True, in_val=str(self.access.sockets),
                          desc="Number of NUMA nodes")
        self.update_value(entry)
        model = self.access.model.split() if self.access.model else None
        model = ' '.join(model) if model else "NA"
        entry = InfoEntry("Model", True, in_val=model,
                          desc="The model of the CPU architecture")
        self.update_value(entry)
        entry = InfoEntry("Vendor", True, in_val=self.access.vendor,
                          desc="The vendor of the CPU")
        self.update_value(entry)
        entry = InfoEntry("Code Name", True,
                          in_val=self.access.architecture,
                          desc="The code name of the CPU")
        self.update_value(entry)
        entry = InfoEntry("Actual Frequency", True,
                          in_val=str(self.access.actual_frequency),
                          desc="The measured CPU frequency")
        self.update_value(entry)
        entry = InfoEntry("Max Frequency", True,
                          in_val=str(self.access.max_frequency),
                          desc="The max supported CPU frequency")
        self.update_value(entry)
