# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Tal Gilboa
# @date: Mar 16, 2017

from performance.services.logger import PerformanceLog
from performance.api.info_entry import InfoEntry
from performance.api.schema_keys import SchemaKeys
from performance.entities.os import OS
from performance.entities.cpu import CPU


class Node(InfoEntry):
    """ Describes a system's information tree
    """
    def __init__(self):
        super(Node, self).__init__(SchemaKeys.SYSTEM_INFO, False)
        self.log = PerformanceLog()

        self.update_value(OS())
        self.update_value(CPU())

    def query(self):
        """ Queries the system for its information.
        """
        for obj in self.api_objects["val"]:
            obj.query()
