# --
# - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --


# @author: Tal Gilboa
# @date: Mar 12, 2017


import json


import neohost_plugin_ifc as APIFC
from request_factory import RequestFactory
from msg_mgr import MsgMgr, MsgConstants
from performance_exceptions import PerformanceException
from performance_defs import PerformanceDefs
from performance.entities.node import Node


class GetSystemStaticPerformanceConfig(APIFC.AbsNeoHostCommandIFC):
    """ API command for getting the system's performance configuration.
        The command will query the system for all relevant information
        and return an output in the format defined by the command's schema.
    """

    def __init__(self):
        super(GetSystemStaticPerformanceConfig, self).__init__(
            cmd_name="GetSystemStaticPerformanceConfig",
            cmd_desc="Get the system's static performance configuration",
            cmd_type=APIFC.EnumCmdType.Cmd_Type_Get,
            cmd_scope=APIFC.EnumCmdScope.Cmd_Scope_System,
            supp_exec_mask=APIFC.EnumCmdExecMode.Cmd_Exec_Mode_All,
            cmd_in_desc="",
            cmd_out_desc="systemInfo: \
                          The system's performance configuration information",
            extra_str="")

    def _getInterface(self, ifcUid):
        """ Get an interface to the command.
        """
        sub_req_obj = RequestFactory.createRequest(
                1, "performance", "GetSystemStaticPerformanceConfig", None)
        _, rc, response = MsgMgr().handle(
                    MsgConstants.NEOHOST_REQUEST, sub_req_obj)
        if rc != 0:
            raise PerformanceException("Failed to get system devices")

    def get_command_gui_metadata(self):
        """ Return a dictionary of the command's GUI metadata data specifically
        tailored for the NeoHost GUI application."""
        return {"excludedAttributes": ["sysInfo.val.OS"]}

    def execute_command(self, json_request, exec_opt):
        """ Execute the get system performance configuration command.
        """
        node = Node()
        node.query()
        return PerformanceDefs.PERFORMANCE_STATUS_SUCCESS,\
            json.dumps(node.to_dictionary())
