# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Tal Gilboa
# @date: Mar 05, 2017

from neohost_plugin_ifc import NeoHostBaseException
from performance_defs import PerformanceDefs
from services.logger import PerformanceLog


class PerformanceException(NeoHostBaseException):
    """ Describes performance plugin exception.
    """
    def __init__(self, msg_str, error_code=1):
        super(PerformanceException, self).__init__(
            msg_str, PerformanceDefs.PERFORMANCE_PLUGIN_NAME, error_code)
        PerformanceLog().get_log().error(msg_str)


class OneOfException(PerformanceException):
    """ Describes analyzer class exception.
    """
    def __init__(self, field, all):
        msg_str = "The {field} should be one of {all}"\
            .format(field=field, all=str(all))
        super(OneOfException, self).__init__(
            msg_str, PerformanceDefs.PERFORMANCE_PLUGIN_NAME)


class NotImplementedError(PerformanceException):
    """ Describes NotImplementedError class exception.
    """
    def __init__(self, field, obj):
        msg_str = "The {field} method is not implemented in {obj} class"\
            .format(field=field, obj=obj)
        super(NotImplementedError, self).__init__(
            msg_str, PerformanceDefs.PERFORMANCE_PLUGIN_NAME)


class NotSupportedException(PerformanceException):
    """ Support service class exception.
    """
    def __init__(self, condition):
        msg_str = ("Performance plugin is not "
                   "supported with {condition}.").format(condition=condition)
        super(NotSupportedException, self).__init__(
            msg_str, PerformanceDefs.PERFORMANCE_PLUGIN_NAME)
