# --
# - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --

# @author: Tal Gilboa
# @date: Mar 05, 2017

from neohost_plugin_ifc import AbsNeoHostPluginIFC
from neohost_common import NeoHostCommon
from performance_defs import PerformanceDefs
from get_system_static_performance_config \
    import GetSystemStaticPerformanceConfig
from get_device_performance_counters import GetDevicePerformanceCounters


class PerformancePlugin(AbsNeoHostPluginIFC):
    """ Describes the performance pluging and supported methods.
    """
    def __init__(self):
        super(PerformancePlugin, self).__init__(
            PerformanceDefs.PERFORMANCE_PLUGIN_NAME,
            PerformanceDefs.PERFORMANCE_PLUGIN_DESC,
            PerformanceDefs.PERFORMANCE_PLUGIN_VER)

        if not NeoHostCommon.isWindowsOs() and not NeoHostCommon.isFreebsdOs():
            self.add_command(GetSystemStaticPerformanceConfig())
            self.add_command(GetDevicePerformanceCounters())
